/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sis.internal.referencing.MathTransformsOrFactory;
import org.apache.sis.internal.referencing.provider.Wraparound;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public class WraparoundTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1959034793759509170L;
    private final int dimension;
    public final int wraparoundDimension;
    public final double period;
    public final double sourceMedian;
    private volatile transient MathTransform inverse;

    protected WraparoundTransform(int n, int n2, double d, double d2) {
        this.dimension = n;
        this.wraparoundDimension = n2;
        this.period = d;
        this.sourceMedian = d2;
    }

    protected WraparoundTransform(WraparoundTransform wraparoundTransform) {
        this.dimension = wraparoundTransform.dimension;
        this.wraparoundDimension = wraparoundTransform.wraparoundDimension;
        this.period = wraparoundTransform.period;
        this.sourceMedian = wraparoundTransform.sourceMedian;
        this.inverse = wraparoundTransform.inverse;
    }

    private WraparoundTransform redim(boolean bl, Matrix matrix) {
        int n = (bl ? matrix.getNumRow() : matrix.getNumCol()) - 1;
        if (n == this.dimension) {
            return this;
        }
        if (n < this.wraparoundDimension && this.getClass() == WraparoundTransform.class) {
            return new WraparoundTransform(n, this.wraparoundDimension, this.period, this.sourceMedian);
        }
        return null;
    }

    public static MathTransform create(int n, int n2, double d, double d2, double d3) {
        ArgumentChecks.ensureStrictlyPositive("dimension", n);
        ArgumentChecks.ensureBetween("wraparoundDimension", 0, n - 1, n2);
        ArgumentChecks.ensureStrictlyPositive("period", d);
        ArgumentChecks.ensureFinite("targetMedian", d3);
        WraparoundTransform wraparoundTransform = new WraparoundTransform(n, n2, d, d2 - d3);
        if (d3 != 0.0) {
            try {
                double[] dArray = new double[n];
                dArray[n2] = d3;
                LinearTransform linearTransform = MathTransforms.translation(dArray);
                wraparoundTransform = MathTransforms.concatenate(linearTransform.inverse(), wraparoundTransform, linearTransform);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(noninvertibleTransformException);
            }
        }
        return wraparoundTransform;
    }

    public static MathTransform replace(MathTransform mathTransform, Function<? super WraparoundTransform, ? extends WraparoundTransform> function) {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        ArgumentChecks.ensureNonNull("replacement", function);
        if (mathTransform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform;
            MathTransform mathTransform2 = WraparoundTransform.replace(concatenatedTransform.transform1, function);
            MathTransform mathTransform3 = WraparoundTransform.replace(concatenatedTransform.transform2, function);
            if (mathTransform2 != concatenatedTransform.transform1 || mathTransform3 != concatenatedTransform.transform2) {
                mathTransform = MathTransforms.concatenate(mathTransform2, mathTransform3);
            }
        } else if (mathTransform instanceof WraparoundTransform) {
            mathTransform = Objects.requireNonNull(function.apply((WraparoundTransform)mathTransform));
        }
        return mathTransform;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    protected double shift(double d) {
        return Math.IEEEremainder(d, this.period);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        if (dArray2 != null) {
            System.arraycopy(dArray, n, dArray2, n2, this.dimension);
            dArray2[n2 += this.wraparoundDimension] = this.shift(dArray2[n2]);
        }
        return bl ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * this.dimension);
        n2 += this.wraparoundDimension;
        while (--n3 >= 0) {
            dArray2[n2] = this.shift(dArray2[n2]);
            n2 += this.dimension;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        System.arraycopy(fArray, n, fArray2, n2, n3 * this.dimension);
        n2 += this.wraparoundDimension;
        while (--n3 >= 0) {
            fArray2[n2] = (float)this.shift(fArray2[n2]);
            n2 += this.dimension;
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return Matrices.createIdentity(this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        MathTransform mathTransform = this.inverse;
        if (mathTransform == null) {
            if (!Double.isFinite(this.sourceMedian)) {
                return super.inverse();
            }
            if (this.sourceMedian == 0.0) {
                this.inverse = mathTransform = this;
            } else {
                WraparoundTransform wraparoundTransform = this;
                synchronized (wraparoundTransform) {
                    mathTransform = this.inverse;
                    if (mathTransform == null) {
                        mathTransform = WraparoundTransform.create(this.dimension, this.wraparoundDimension, this.period, 0.0, this.sourceMedian);
                        ConcatenatedTransform.setInverse(mathTransform, this);
                        this.inverse = mathTransform;
                    }
                }
            }
        }
        return mathTransform;
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        block10: {
            MathTransform mathTransform2;
            Matrix matrix;
            if (mathTransform instanceof WraparoundTransform && this.equalsIgnoreInverse((WraparoundTransform)mathTransform)) {
                return bl ? mathTransform : this;
            }
            List<MathTransform> list = MathTransforms.getSteps(mathTransform);
            int n = list.size();
            if (n >= 2 && (matrix = MathTransforms.getMatrix(mathTransform2 = list.get(bl ? n - 1 : 0))) != null) {
                try {
                    Matrix matrix2;
                    Matrix matrix3;
                    WraparoundTransform wraparoundTransform;
                    MathTransformsOrFactory mathTransformsOrFactory = MathTransformsOrFactory.wrap(mathTransformFactory);
                    boolean bl2 = false;
                    WraparoundTransform wraparoundTransform2 = this;
                    MathTransform mathTransform3 = this.movable(mathTransform2, matrix, mathTransformsOrFactory);
                    if (mathTransform3 != null && (wraparoundTransform = this.redim(bl, matrix3 = WraparoundTransform.remaining(bl, mathTransform3, matrix))) != null) {
                        wraparoundTransform2 = mathTransformsOrFactory.concatenate(bl, mathTransform3, wraparoundTransform);
                        matrix = matrix3;
                        bl2 = true;
                    }
                    if ((matrix3 = list.get(bl ? n - 2 : 1)) instanceof WraparoundTransform && (mathTransform3 = (wraparoundTransform = (WraparoundTransform)matrix3).movable(null, matrix, mathTransformsOrFactory)) != null && (wraparoundTransform = wraparoundTransform.redim(!bl, matrix2 = WraparoundTransform.remaining(!bl, mathTransform3, matrix))) != null) {
                        matrix3 = mathTransformsOrFactory.concatenate(bl, wraparoundTransform, mathTransform3);
                        matrix = matrix2;
                        bl2 = true;
                    }
                    if (!bl2 || (wraparoundTransform = mathTransformsOrFactory.linear(matrix)).getClass() == mathTransform2.getClass()) break block10;
                    wraparoundTransform = mathTransformsOrFactory.concatenate(bl, wraparoundTransform, (MathTransform)matrix3);
                    wraparoundTransform = mathTransformsOrFactory.concatenate(bl, wraparoundTransform2, wraparoundTransform);
                    if (bl) {
                        int n2 = n - 2;
                        while (--n2 >= 0) {
                            wraparoundTransform = mathTransformsOrFactory.concatenate(list.get(n2), wraparoundTransform);
                        }
                    } else {
                        for (int i = 2; i < n; ++i) {
                            wraparoundTransform = mathTransformsOrFactory.concatenate(wraparoundTransform, list.get(i));
                        }
                    }
                    return wraparoundTransform;
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing"), this.getClass(), "tryConcatenate", noninvertibleTransformException);
                }
            }
        }
        return null;
    }

    private MathTransform movable(MathTransform mathTransform, Matrix matrix, MathTransformsOrFactory mathTransformsOrFactory) throws FactoryException {
        int n;
        long l;
        long l2 = l = Numerics.bitmask(this.dimension) - 1L;
        int n2 = matrix.getNumCol() - 1;
        if (this.wraparoundDimension < n2) {
            n = matrix.getNumRow();
            while (--n >= 0) {
                double d = matrix.getElement(n, this.wraparoundDimension);
                if (d == (double)(n == this.wraparoundDimension ? 1 : 0)) continue;
                l2 &= Numerics.bitmask(n) ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (matrix.getElement(this.wraparoundDimension, n2) != 0.0) {
            l2 &= Numerics.bitmask(this.wraparoundDimension) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l2 != 0L) {
            if (l2 != l) {
                matrix = Matrices.copy(matrix);
                n = matrix.getNumRow() - 1;
                while (--n >= 0) {
                    if ((l2 & Numerics.bitmask(n)) != 0L) continue;
                    int n3 = matrix.getNumCol();
                    while (--n3 >= 0) {
                        matrix.setElement(n, n3, n3 == n ? 1.0 : 0.0);
                    }
                }
            } else if (mathTransform != null) {
                return mathTransform;
            }
            if (!matrix.isIdentity()) {
                return mathTransformsOrFactory.linear(matrix);
            }
        }
        return null;
    }

    private static Matrix remaining(boolean bl, MathTransform mathTransform, Matrix matrix) throws NoninvertibleTransformException {
        Matrix matrix2 = MathTransforms.getMatrix(mathTransform.inverse());
        return bl ? Matrices.multiply(matrix2, matrix) : Matrices.multiply(matrix, matrix2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Wraparound.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters parameters = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        parameters.getOrCreate(Wraparound.DIMENSION).setValue(this.dimension);
        parameters.getOrCreate(Wraparound.WRAPAROUND_DIMENSION).setValue(this.wraparoundDimension);
        parameters.getOrCreate(Wraparound.PERIOD).setValue(this.period);
        return parameters;
    }

    private boolean equalsIgnoreInverse(WraparoundTransform wraparoundTransform) {
        return wraparoundTransform.dimension == this.dimension && wraparoundTransform.wraparoundDimension == this.wraparoundDimension && Numerics.equals(this.period, wraparoundTransform.period);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            WraparoundTransform wraparoundTransform = (WraparoundTransform)object;
            return this.equalsIgnoreInverse(wraparoundTransform) && Numerics.equals(this.sourceMedian, wraparoundTransform.sourceMedian);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return this.dimension * 31 + this.wraparoundDimension + Double.hashCode(this.period) + 7 * Double.hashCode(this.sourceMedian);
    }
}

