/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDiscoveryServiceImpl
extends InMemoryAbstractServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDiscoveryServiceImpl.class);

    public InMemoryDiscoveryServiceImpl(StoreManager storeManager) {
        super(storeManager);
    }

    public ObjectList getContentChanges(CallContext context, String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        int ITEMS_AVAILABLE = 25;
        int token = 0;
        if (changeLogToken != null && changeLogToken.getValue() != null) {
            if (!((String)changeLogToken.getValue()).startsWith("token-")) {
                throw new CmisInvalidArgumentException("Unknown change log token!");
            }
            try {
                token = Integer.parseInt(((String)changeLogToken.getValue()).substring(6));
            }
            catch (NumberFormatException nfe) {
                throw new CmisInvalidArgumentException("Unknown change log token!", (Throwable)nfe);
            }
            if (token < 0 || token > 25) {
                throw new CmisInvalidArgumentException("Unknown change log token!");
            }
        }
        ObjectListImpl objList = new ObjectListImpl();
        long timestamp = System.currentTimeMillis() - 60000L;
        ArrayList<ObjectDataImpl> lod = new ArrayList<ObjectDataImpl>();
        if (null == maxItems) {
            maxItems = BigInteger.valueOf(25L);
        }
        int last = Math.min(25, token + maxItems.intValue());
        for (int i = token; i < last; ++i) {
            ObjectDataImpl odImpl = new ObjectDataImpl();
            PropertiesImpl props = new PropertiesImpl();
            props.addProperty((PropertyData)new PropertyIdImpl("cmis:objectId", "cl-" + i));
            props.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value()));
            props.addProperty((PropertyData)new PropertyIdImpl("cmis:baseTypeId", BaseTypeId.CMIS_DOCUMENT.value()));
            odImpl.setProperties((Properties)props);
            ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
            changeEventInfo.setChangeType(ChangeType.DELETED);
            GregorianCalendar eventTimestamp = new GregorianCalendar();
            eventTimestamp.setTimeInMillis(timestamp + (long)(i * 1000));
            changeEventInfo.setChangeTime(eventTimestamp);
            odImpl.setChangeEventInfo((ChangeEventInfo)changeEventInfo);
            if (includePolicyIds != null && includePolicyIds.booleanValue()) {
                PolicyIdListImpl policies = new PolicyIdListImpl();
                odImpl.setPolicyIds((PolicyIdList)policies);
            }
            lod.add(odImpl);
        }
        objList.setObjects(lod);
        objList.setNumItems(BigInteger.valueOf(25 - token));
        objList.setHasMoreItems(Boolean.valueOf(false));
        String changeToken = "token-" + (token + lod.size() - 1);
        if (changeLogToken != null) {
            changeLogToken.setValue((Object)changeToken);
        }
        if (objectInfos != null) {
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, null, objectInfos, (ObjectList)objList);
        }
        return objList;
    }

    private void convertList(List<ObjectData> lod, ObjectInFolderContainer obj) {
        lod.add(obj.getObject().getObject());
        ObjectData oif = obj.getObject().getObject();
        ObjectDataImpl oifImpl = (ObjectDataImpl)oif;
        ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
        changeEventInfo.setChangeType(ChangeType.UPDATED);
        changeEventInfo.setChangeTime(new GregorianCalendar());
        oifImpl.setChangeEventInfo((ChangeEventInfo)changeEventInfo);
        if (null != obj.getChildren()) {
            for (ObjectInFolderContainer oifc : obj.getChildren()) {
                this.convertList(lod, oifc);
            }
        }
    }

    public ObjectList query(CallContext context, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        LOG.debug("start query()");
        this.validator.query(context, repositoryId, extension);
        String user = context.getUsername();
        ObjectList res = this.fStoreManager.query(context, user, repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        LOG.debug("stop query()");
        return res;
    }
}

