/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.ComponentLookupManager;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.UndefinedComponentManagerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;

public class DefaultComponentLookupManager
implements ComponentLookupManager {
    private MutablePlexusContainer container;

    public Object lookup(String componentRole) throws ComponentLookupException {
        return this.lookup(componentRole, this.container.getLookupRealm());
    }

    public Object lookup(String componentRole, ClassRealm realm) throws ComponentLookupException {
        Object component;
        ComponentManager componentManager = this.container.getComponentManagerManager().findComponentManagerByComponentKey(componentRole, realm);
        if (this.container.isReloadingEnabled() || componentManager == null) {
            ComponentDescriptor descriptor = this.container.getComponentRepository().getComponentDescriptor(componentRole, realm);
            if (descriptor == null) {
                if (this.container.getParentContainer() != null) {
                    return this.container.getParentContainer().lookup(componentRole, realm);
                }
                String message = "Component descriptor cannot be found in the component repository: " + componentRole + " (lookup realm: " + realm + ").";
                throw new ComponentLookupException(message);
            }
            componentManager = this.createComponentManager(descriptor, componentRole);
        }
        try {
            component = componentManager.getComponent(realm);
        }
        catch (ComponentInstantiationException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentRole + "', it could not be created", (Throwable)e);
        }
        catch (ComponentLifecycleException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentRole + "', it could not be started", (Throwable)e);
        }
        this.container.getComponentManagerManager().associateComponentWithComponentManager(component, componentManager);
        return component;
    }

    public Object lookup(Class componentClass) throws ComponentLookupException {
        return this.lookup(componentClass.getName(), this.container.getLookupRealm());
    }

    public Object lookup(Class componentClass, ClassRealm realm) throws ComponentLookupException {
        return this.lookup(componentClass.getName(), realm);
    }

    public Object lookup(Class role, String roleHint, ClassRealm realm) throws ComponentLookupException {
        return this.lookup(role.getName(), roleHint, realm);
    }

    public Object lookup(String role, String roleHint, ClassRealm realm) throws ComponentLookupException {
        return this.lookup(role + roleHint, realm);
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.lookup(role + roleHint);
    }

    public Object lookup(Class role, String roleHint) throws ComponentLookupException {
        return this.lookup(role.getName(), roleHint);
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        return this.lookupMap(role, this.container.getLookupRealm());
    }

    public Map lookupMap(Class role, ClassRealm realm) throws ComponentLookupException {
        return this.lookupMap(role.getName(), realm);
    }

    public Map lookupMap(String role, ClassRealm realm) throws ComponentLookupException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        Map componentDescriptors = this.container.getComponentDescriptorMap(role, realm);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.keySet().iterator();
            while (i.hasNext()) {
                String roleHint = (String)i.next();
                Object component = this.lookup(role, roleHint, realm);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    public Map lookupMap(Class role) throws ComponentLookupException {
        return this.lookupMap(role.getName());
    }

    public List lookupList(String role) throws ComponentLookupException {
        return this.lookupList(role, this.container.getLookupRealm());
    }

    public List lookupList(Class role) throws ComponentLookupException {
        return this.lookupList(role.getName(), this.container.getLookupRealm());
    }

    public List lookupList(Class role, ClassRealm realm) throws ComponentLookupException {
        return this.lookupList(role.getName(), realm);
    }

    public List lookupList(String role, ClassRealm realm) throws ComponentLookupException {
        ArrayList<Object> components = new ArrayList<Object>();
        List componentDescriptors = this.container.getComponentDescriptorList(role, realm);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.iterator();
            while (i.hasNext()) {
                ComponentDescriptor descriptor = (ComponentDescriptor)i.next();
                String roleHint = descriptor.getRoleHint();
                Object component = roleHint != null ? this.lookup(role, roleHint, realm) : this.lookup(role, realm);
                components.add(component);
            }
        }
        return components;
    }

    public void setContainer(MutablePlexusContainer container) {
        this.container = container;
    }

    private ComponentManager createComponentManager(ComponentDescriptor descriptor, String componentKey) throws ComponentLookupException {
        ComponentManager componentManager;
        try {
            componentManager = this.container.getComponentManagerManager().createComponentManager(descriptor, this.container, componentKey);
        }
        catch (UndefinedComponentManagerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, (Throwable)e);
        }
        catch (UndefinedLifecycleHandlerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, (Throwable)e);
        }
        return componentManager;
    }
}

