/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.collections.ActiveSet;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractActiveSet
implements ActiveSet {
    private String role;
    private PlexusContainer container;
    private Logger logger;

    protected AbstractActiveSet() {
    }

    protected AbstractActiveSet(PlexusContainer container, String role) {
        this.container = container;
        this.role = role;
        this.logger = container.getLoggerManager().getLoggerForComponent(ActiveSet.ROLE);
    }

    public boolean add(Object arg0) {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    public void clear() {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("ActiveSet implementations are not mutable.");
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final Set getSet() {
        try {
            return this.checkedGetSet();
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup map for role: " + this.role, (Throwable)e);
            return Collections.EMPTY_SET;
        }
    }

    protected final Set checkedGetSet() throws ComponentLookupException {
        return new LinkedHashSet(this.container.lookupList(this.role));
    }

    public final String getRole() {
        return this.role;
    }

    protected final void setRole(String role) {
        this.role = role;
    }

    public final void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public final void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public abstract /* synthetic */ Object[] checkedToArray(Object[] var1) throws ComponentLookupException;

    public abstract /* synthetic */ Object[] checkedToArray() throws ComponentLookupException;

    public abstract /* synthetic */ Iterator checkedIterator() throws ComponentLookupException;

    public abstract /* synthetic */ boolean checkedContainsAll(Collection var1) throws ComponentLookupException;

    public abstract /* synthetic */ boolean checkedContains(Object var1) throws ComponentLookupException;

    public abstract /* synthetic */ int checkedSize() throws ComponentLookupException;

    public abstract /* synthetic */ int size();

    public abstract /* synthetic */ boolean checkedIsEmpty() throws ComponentLookupException;

    public abstract /* synthetic */ boolean isEmpty();

    public abstract /* synthetic */ Object[] toArray(Object[] var1);

    public abstract /* synthetic */ Iterator iterator();

    public abstract /* synthetic */ boolean containsAll(Collection var1);

    public abstract /* synthetic */ boolean contains(Object var1);

    public abstract /* synthetic */ Object[] toArray();
}

