<!---
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

# Maven Wrapper

The Maven Wrapper is an easy way to ensure a user of your Maven build has
everything necessary to run your Maven build.

_Why might this be necessary?_ Maven has been very stable for users, is
available on most systems, and is easy to procure. However, with many of the recent
changes in Maven it will be easier for users to have a fully encapsulated build
setup provided by the project. With the Maven Wrapper, this is very easy to do.

The easiest way to set up the Maven Wrapper for a project is to use the
[Maven Wrapper Plugin][1] with its provided `wrapper` goal. To add or update all
the necessary Maven Wrapper files to your project, execute the following command:

```bash
mvn wrapper:wrapper
```

Previously you instructed users to install a specific version of Apache Maven, put
it on the PATH, and then run the `mvn` command like the following:

```bash
mvn clean install
```

But now, with a Maven Wrapper setup, you can instruct users to run wrapper
scripts:

```bash
./mvnw clean install
```

or on Windows

```bash
mvnw.cmd clean install
```

A normal Maven build will be executed, with the one important change that if the
user doesn't have the necessary version of Maven specified in
`.mvn/wrapper/maven-wrapper.properties` it will be downloaded for the user
first, installed and then used.

Subsequent uses of `mvnw`/`mvnw.cmd` use the previously downloaded, specific
version as needed.

## Supported Systems

The wrapper should work on various operating systems including

* Linux (numerous versions, tested on Ubuntu and CentOS)
* OSX / macOS
* Windows (various newer versions)
* Solaris (10 and 11)
* BSD

A POSIX-compatible Bourne shell is required to run the wrapper script.

In terms of Apache Maven versions itself, the wrapper should work with any Maven
3.x version or later. It defaults to the release used when setting up the wrapper. We do NOT
support the deprecated, EOL'ed Maven 2.x.

By default, the `only-script` type is installed (see below).

## Verbose Mode

The wrapper supports a verbose mode in which it outputs further information. It
is activated by setting the `MVNW_VERBOSE` environment variable to `true`.

By default, it is off.

## Usage with or without Binary JAR

Using `type=bin`, the Maven Wrapper JAR archive is added to the using project as small
binary file `.mvn/wrapper/maven-wrapper.jar`. It is used to bootstrap the
download and invocation of Maven from the wrapper shell scripts.

If your project is not allowed to contain binary files like this, you can
use the source distribution of the maven wrapper which adds a file
`.mvn/wrapper/MavenWrapperDownloader.java` file instead:

```shell
mvn wrapper:wrapper -Dtype=source 
```

You can also choose to opt out of all additional resources except the wrapper scripts:

```shell
mvn wrapper:wrapper -Dtype=script
```

Another type is the lite implementation of `mvnw`/`mvnw.cmd` scripts which download the maven directly 
via wget or curl on *nix, or PowerShell on Windows, then call the original `mvn`/`mvn.cmd` 
scripts of the downloaded maven distribution. 
This type does not use `maven-wrapper.jar` nor `MavenWrapperDownloader.java`, only the wrapper scripts are required.
This is the default type being installed, when no type parameter is specified.

```shell
mvn wrapper:wrapper -Dtype=only-script
```

If the JAR is not found to be available by the scripts they will attempt to
download the file from the URL specified in
`.mvn/wrapper/maven-wrapper.properties` under `wrapperUrl` and put it in place.
The download is attempted via curl, wget and, as last resort, by compiling the
`.mvn/wrapper/MavenWrapperDownloader.java` file and executing the resulting
class.

If your Maven repository is password protected you can specify your username via
the environment variable `MVNW_USERNAME` and the password via the environment
variable `MVNW_PASSWORD`.

## Using a Different Version of Maven

To switch the version of Maven used to build a project, you can initialize it
using:

```bash
mvn wrapper:wrapper -Dmaven=3.5.4
```

which works for any version including snapshots. Once you have a wrapper you can
change its version by setting the `distributionUrl` in
`.mvn/wrapper/maven-wrapper.properties`, e.g.

```bash
distributionUrl=https://repo.maven.apache.org/maven2/org/apache/maven/apache-maven/3.5.4/apache-maven-3.5.4-bin.zip
```

For snapshot versions, you can use URLs like:

```bash
distributionUrl=https://repository.apache.org/content/repositories/snapshots/org/apache/maven/apache-maven/4.1.0-SNAPSHOT/apache-maven-4.1.0-20250710.120440-1-bin.zip
```

## Using Basic Authentication for Distribution Download

To download Maven from a location that requires Basic Authentication you have 2
options:

1. Set the environment variables `MVNW_USERNAME` and `MVNW_PASSWORD`

    or

2. add user and password to the distributionUrl like that:
`distributionUrl=https://username:password@<yourserver>/maven2/org/apache/maven/apache-maven/3.2.1/apache-maven-3.2.1-bin.zip`

[1]: ./maven-wrapper-plugin

## Specifying Maven Distribution Base Path

Environment variable `MAVEN_USER_HOME` can be set to the path which will be used by the wrapper as the base of the Maven distro installation.
By default, the wrapper uses the `$HOME/.m2` as the base directory for installation.

See https://github.com/takari/maven-wrapper/issues/17

## Using a Maven Repository Manager

When using an internal Maven repository manager, you have two options:

1. Set the correct URL to wrapper jar and Maven distro in
  `maven-wrapper.properties` in your project
2. Leave the default URL in the project pointing to Maven Central and set the
  environment variable `MVNW_REPOURL` to your repo manager URL such as
  `https://repo.example.com/central-repo-proxy`.

If `MVNW_REPOURL` is set during the wrapper installation with the
maven-wrapper-plugin, the URL is used in the maven-wrapper.properties file.

If not set, but your mirror URL in your settings.xml is configured, it will be
used.

## Checksum verification of downloaded binaries

To avoid supply-chain-attacks by downloading a corrupted artifact, it
is possible to specify checksums for both the *maven-wrapper.jar* and 
the downloaded distribution. To apply verification, add the expected
file's SHA-256 sum in hex notation, using only small caps, to 
`maven-wrapper.properties`. The property for validating the 
*maven-wrapper.jar* file is named `wrapperSha256Sum` whereas the 
distribution file property is named `distributionSha256Sum`.

## Internals

Maven Wrapper is composed of 3 pieces:
 
1. [maven-wrapper](./maven-wrapper/), providing the `maven-wrapper.jar` that downloads, installs and runs target Maven distribution,

2. [maven-wrapper-distribution](./maven-wrapper-distribution/), that provides `mvnw`/`mvnw.cmd` scripts distributions,

3. [maven-wrapper-plugin](./maven-wrapper-plugin/), the `wrapper` plugin to ease installing Wrapper into a project.
