/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.nio.charset.Charset;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.file.splitter.FileSplitter;
import org.springframework.util.StringUtils;

public class FileSplitterSpec
extends MessageHandlerSpec<FileSplitterSpec, FileSplitter> {
    private final boolean iterator;
    private boolean markers;
    private boolean markersJson;
    private Charset charset;
    private boolean applySequence;
    private String firstLineHeaderName;

    protected FileSplitterSpec() {
        this(true);
    }

    protected FileSplitterSpec(boolean iterator) {
        this(iterator, false);
    }

    protected FileSplitterSpec(boolean iterator, boolean markers) {
        this.iterator = iterator;
        this.markers = markers;
    }

    public FileSplitterSpec charset(String charset) {
        return this.charset(Charset.forName(charset));
    }

    public FileSplitterSpec charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public FileSplitterSpec markers() {
        return this.markers(false);
    }

    public FileSplitterSpec markers(boolean asJson) {
        this.markers = true;
        this.markersJson = asJson;
        return this;
    }

    public FileSplitterSpec applySequence(boolean applySequence) {
        this.applySequence = applySequence;
        return this;
    }

    public FileSplitterSpec firstLineAsHeader(String firstLineHeaderName) {
        this.firstLineHeaderName = firstLineHeaderName;
        return this;
    }

    protected FileSplitter doGet() {
        FileSplitter fileSplitter = new FileSplitter(this.iterator, this.markers, this.markersJson);
        fileSplitter.setApplySequence(this.applySequence);
        fileSplitter.setCharset(this.charset);
        if (StringUtils.hasText((String)this.firstLineHeaderName)) {
            fileSplitter.setFirstLineAsHeader(this.firstLineHeaderName);
        }
        return fileSplitter;
    }
}

