/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.mina.MinaAcceptor;
import org.apache.sshd.mina.MinaConnector;

public class MinaServiceFactory
extends AbstractIoServiceFactory {
    private final IoProcessor<NioSession> ioProcessor;

    public MinaServiceFactory(FactoryManager factoryManager, CloseableExecutorService service) {
        super(factoryManager, ThreadUtils.newCachedThreadPoolIf((CloseableExecutorService)service, (String)(factoryManager.toString() + "-mina")));
        this.ioProcessor = new SimpleIoProcessorPool(MinaProcessor.class, (Executor)this.getExecutorService(), MinaServiceFactory.getNioWorkers((FactoryManager)factoryManager), null);
    }

    public IoConnector createConnector(IoHandler handler) {
        return (IoConnector)this.autowireCreatedService(new MinaConnector(this.getFactoryManager(), handler, this.ioProcessor));
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return (IoAcceptor)this.autowireCreatedService(new MinaAcceptor(this.getFactoryManager(), handler, this.ioProcessor));
    }

    protected void doCloseImmediately() {
        try {
            this.ioProcessor.dispose();
        }
        catch (Exception e) {
            this.log.debug("Exception caught while disposing IoProcessor pool", (Throwable)e);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    protected static class MinaProcessor
    extends NioProcessor {
        public MinaProcessor(Executor executor) {
            super(executor);
        }

        public MinaProcessor(Executor executor, SelectorProvider selectorProvider) {
            super(executor, selectorProvider);
        }

        protected void setInterestedInRead(NioSession session, boolean isInterested) throws Exception {
            boolean startReading = isInterested && !this.isInterestedInRead(session);
            super.setInterestedInRead(session, isInterested);
            if (startReading) {
                this.wakeup();
            }
        }
    }
}

