/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AreaFormatRecord
extends Record {
    public static final short sid = 4106;
    private int field_1_foregroundColor;
    private int field_2_backgroundColor;
    private short field_3_pattern;
    private short field_4_formatFlags;
    private BitField automatic = new BitField(1);
    private BitField invert = new BitField(2);
    private short field_5_forecolorIndex;
    private short field_6_backcolorIndex;

    public AreaFormatRecord() {
    }

    public AreaFormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AreaFormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4106) {
            throw new RecordFormatException("Not a AreaFormat record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_foregroundColor = LittleEndian.getInt(data, pos + 0 + offset);
        this.field_2_backgroundColor = LittleEndian.getInt(data, pos + 4 + offset);
        this.field_3_pattern = LittleEndian.getShort(data, pos + 8 + offset);
        this.field_4_formatFlags = LittleEndian.getShort(data, pos + 10 + offset);
        this.field_5_forecolorIndex = LittleEndian.getShort(data, pos + 12 + offset);
        this.field_6_backcolorIndex = LittleEndian.getShort(data, pos + 14 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AREAFORMAT]\n");
        buffer.append("    .foregroundColor      = ").append("0x").append(HexDump.toHex(this.getForegroundColor())).append(" (").append(this.getForegroundColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .backgroundColor      = ").append("0x").append(HexDump.toHex(this.getBackgroundColor())).append(" (").append(this.getBackgroundColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .pattern              = ").append("0x").append(HexDump.toHex(this.getPattern())).append(" (").append(this.getPattern()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .automatic                = ").append(this.isAutomatic()).append('\n');
        buffer.append("         .invert                   = ").append(this.isInvert()).append('\n');
        buffer.append("    .forecolorIndex       = ").append("0x").append(HexDump.toHex(this.getForecolorIndex())).append(" (").append(this.getForecolorIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .backcolorIndex       = ").append("0x").append(HexDump.toHex(this.getBackcolorIndex())).append(" (").append(this.getBackcolorIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AREAFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4106);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset + pos, this.field_1_foregroundColor);
        LittleEndian.putInt(data, 8 + offset + pos, this.field_2_backgroundColor);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_3_pattern);
        LittleEndian.putShort(data, 14 + offset + pos, this.field_4_formatFlags);
        LittleEndian.putShort(data, 16 + offset + pos, this.field_5_forecolorIndex);
        LittleEndian.putShort(data, 18 + offset + pos, this.field_6_backcolorIndex);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 4106;
    }

    public Object clone() {
        AreaFormatRecord rec = new AreaFormatRecord();
        rec.field_1_foregroundColor = this.field_1_foregroundColor;
        rec.field_2_backgroundColor = this.field_2_backgroundColor;
        rec.field_3_pattern = this.field_3_pattern;
        rec.field_4_formatFlags = this.field_4_formatFlags;
        rec.field_5_forecolorIndex = this.field_5_forecolorIndex;
        rec.field_6_backcolorIndex = this.field_6_backcolorIndex;
        return rec;
    }

    public int getForegroundColor() {
        return this.field_1_foregroundColor;
    }

    public void setForegroundColor(int field_1_foregroundColor) {
        this.field_1_foregroundColor = field_1_foregroundColor;
    }

    public int getBackgroundColor() {
        return this.field_2_backgroundColor;
    }

    public void setBackgroundColor(int field_2_backgroundColor) {
        this.field_2_backgroundColor = field_2_backgroundColor;
    }

    public short getPattern() {
        return this.field_3_pattern;
    }

    public void setPattern(short field_3_pattern) {
        this.field_3_pattern = field_3_pattern;
    }

    public short getFormatFlags() {
        return this.field_4_formatFlags;
    }

    public void setFormatFlags(short field_4_formatFlags) {
        this.field_4_formatFlags = field_4_formatFlags;
    }

    public short getForecolorIndex() {
        return this.field_5_forecolorIndex;
    }

    public void setForecolorIndex(short field_5_forecolorIndex) {
        this.field_5_forecolorIndex = field_5_forecolorIndex;
    }

    public short getBackcolorIndex() {
        return this.field_6_backcolorIndex;
    }

    public void setBackcolorIndex(short field_6_backcolorIndex) {
        this.field_6_backcolorIndex = field_6_backcolorIndex;
    }

    public void setAutomatic(boolean value) {
        this.field_4_formatFlags = this.automatic.setShortBoolean(this.field_4_formatFlags, value);
    }

    public boolean isAutomatic() {
        return this.automatic.isSet(this.field_4_formatFlags);
    }

    public void setInvert(boolean value) {
        this.field_4_formatFlags = this.invert.setShortBoolean(this.field_4_formatFlags, value);
    }

    public boolean isInvert() {
        return this.invert.isSet(this.field_4_formatFlags);
    }
}

