/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFFont;

public class HSSFRichTextString
implements Comparable {
    public static final short NO_FONT = -1;
    String string;
    SortedMap formattingRuns = new TreeMap();

    public HSSFRichTextString() {
        this("");
    }

    public HSSFRichTextString(String string) {
        this.string = string;
        this.formattingRuns.put(new Integer(0), new Short(-1));
    }

    public void applyFont(int startIndex, int endIndex, short fontIndex) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (startIndex < 0 || endIndex > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (startIndex == endIndex) {
            return;
        }
        Integer from = new Integer(startIndex);
        Integer to = new Integer(endIndex);
        short fontAtIndex = -1;
        if (endIndex != this.length()) {
            fontAtIndex = this.getFontAtIndex(endIndex);
        }
        this.formattingRuns.subMap(from, to).clear();
        this.formattingRuns.put(from, new Short(fontIndex));
        if (endIndex != this.length() && fontIndex != fontAtIndex) {
            this.formattingRuns.put(to, new Short(fontAtIndex));
        }
    }

    public void applyFont(int startIndex, int endIndex, HSSFFont font) {
        this.applyFont(startIndex, endIndex, font.getIndex());
    }

    public void applyFont(HSSFFont font) {
        this.applyFont(0, this.string.length(), font);
    }

    public String getString() {
        return this.string;
    }

    public int length() {
        return this.string.length();
    }

    public short getFontAtIndex(int index) {
        if (index < 0 || index >= this.string.length()) {
            throw new ArrayIndexOutOfBoundsException("Font index " + index + " out of bounds of string");
        }
        Integer key = new Integer(index + 1);
        SortedMap head = this.formattingRuns.headMap(key);
        if (head.isEmpty()) {
            throw new IllegalStateException("Should not reach here.  No font found.");
        }
        return (Short)head.get(head.lastKey());
    }

    public int numFormattingRuns() {
        return this.formattingRuns.size();
    }

    public int getIndexOfFormattingRun(int index) {
        Map.Entry[] runs = this.formattingRuns.entrySet().toArray(new Map.Entry[this.formattingRuns.size()]);
        return (Integer)runs[index].getKey();
    }

    public short getFontOfFormattingRun(int index) {
        Map.Entry[] runs = this.formattingRuns.entrySet().toArray(new Map.Entry[this.formattingRuns.size()]);
        return (Short)runs[index].getValue();
    }

    public int compareTo(Object o) {
        return 0;
    }

    public String toString() {
        return this.string;
    }

    public void applyFont(short fontIndex) {
        this.applyFont(0, this.string.length(), fontIndex);
    }
}

