/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public class HtmlEncoder {
    private static final String[] htmlCode = new String[256];

    static {
        int i = 0;
        while (i < 10) {
            HtmlEncoder.htmlCode[i] = "&#00" + i + ";";
            ++i;
        }
        i = 10;
        while (i < 32) {
            HtmlEncoder.htmlCode[i] = "&#0" + i + ";";
            ++i;
        }
        i = 32;
        while (i < 128) {
            HtmlEncoder.htmlCode[i] = String.valueOf((char)i);
            ++i;
        }
        HtmlEncoder.htmlCode[9] = "\t";
        HtmlEncoder.htmlCode[10] = "<br />\n";
        HtmlEncoder.htmlCode[34] = "&quot;";
        HtmlEncoder.htmlCode[38] = "&amp;";
        HtmlEncoder.htmlCode[60] = "&lt;";
        HtmlEncoder.htmlCode[62] = "&gt;";
        i = 128;
        while (i < 256) {
            HtmlEncoder.htmlCode[i] = "&#" + i + ";";
            ++i;
        }
    }

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n = string.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < n) {
            char character = string.charAt(i);
            if (character < '\u0100') {
                buffer.append(htmlCode[character]);
            } else {
                buffer.append("&#").append((int)character).append(';');
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    public static String encode(Color color) {
        StringBuffer buffer = new StringBuffer("#");
        if (color.getRed() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getBlue(), 16));
        return buffer.toString();
    }

    public static String getAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: 
            case 8: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "";
    }
}

