/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;

public class ValueRecordsAggregate
extends Record {
    public static final short sid = -1000;
    int firstcell = -1;
    int lastcell = -1;
    TreeMap records = new TreeMap();

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface o = this.records.put(cell, cell);
        if (cell.getColumn() < this.firstcell || this.firstcell == -1) {
            this.firstcell = cell.getColumn();
        }
        if (cell.getColumn() > this.lastcell || this.lastcell == -1) {
            this.lastcell = cell.getColumn();
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        this.records.remove(cell);
    }

    public int getPhysicalNumberOfCells() {
        return this.records.size();
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int offset, List records) {
        Record rec;
        int k = 0;
        FormulaRecordAggregate lastFormulaAggregate = null;
        for (k = offset; k < records.size() && ((rec = (Record)records.get(k)) instanceof StringRecord || rec.isInValueSection() || rec instanceof UnknownRecord); ++k) {
            if (rec instanceof FormulaRecord) {
                lastFormulaAggregate = new FormulaRecordAggregate((FormulaRecord)rec, null);
                this.insertCell(lastFormulaAggregate);
                continue;
            }
            if (rec instanceof StringRecord) {
                lastFormulaAggregate.setStringRecord((StringRecord)rec);
                continue;
            }
            if (rec instanceof SharedFormulaRecord) {
                lastFormulaAggregate.setSharedFormulaRecord((SharedFormulaRecord)rec);
                continue;
            }
            if (!rec.isValue()) continue;
            this.insertCell((CellValueRecordInterface)((Object)rec));
        }
        return k;
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.values().iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        int size = 0;
        Iterator irecs = this.records.values().iterator();
        while (irecs.hasNext()) {
            size += ((Record)irecs.next()).getRecordSize();
        }
        return size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    public Object clone() {
        ValueRecordsAggregate rec = new ValueRecordsAggregate();
        Iterator valIter = this.getIterator();
        while (valIter.hasNext()) {
            CellValueRecordInterface val = (CellValueRecordInterface)((CellValueRecordInterface)valIter.next()).clone();
            rec.insertCell(val);
        }
        return rec;
    }
}

