/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.application.DefaultResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceHandlerCache;
import org.apache.myfaces.shared.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceImpl;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceValidationUtils;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class ResourceHandlerImpl
extends ResourceHandler {
    private static final String IS_RESOURCE_REQUEST = "org.apache.myfaces.IS_RESOURCE_REQUEST";
    private ResourceHandlerSupport _resourceHandlerSupport;
    private ResourceHandlerCache _resourceHandlerCache;
    private static final Logger log = Logger.getLogger(ResourceHandlerImpl.class.getName());
    public static final String INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME = "org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME";
    public static final boolean INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME_DEFAULT = false;
    public static final String INIT_PARAM_RESOURCE_BUFFER_SIZE = "org.apache.myfaces.RESOURCE_BUFFER_SIZE";
    public static final int INIT_PARAM_RESOURCE_BUFFER_SIZE_DEFAULT = 2048;
    private Boolean _allowSlashLibraryName;
    private int _resourceBufferSize = -1;
    private String[] _excludedResourceExtensions;

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceImpl resource = null;
        if (!ResourceValidationUtils.isValidResourceName(resourceName)) {
            return null;
        }
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return null;
        }
        if (contentType == null) {
            contentType = FacesContext.getCurrentInstance().getExternalContext().getMimeType(resourceName);
        }
        String localePrefix = this.getLocalePrefixForLocateResource();
        if (this.getResourceLoaderCache().containsResource(resourceName, libraryName, contentType, localePrefix)) {
            ResourceHandlerCache.ResourceValue resourceValue = this.getResourceLoaderCache().getResource(resourceName, libraryName, contentType, localePrefix);
            resource = new ResourceImpl(resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType);
        } else {
            for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                ResourceMeta resourceMeta = this.deriveResourceMeta(loader, resourceName, libraryName, localePrefix);
                if (resourceMeta == null) continue;
                resource = new ResourceImpl(resourceMeta, loader, this.getResourceHandlerSupport(), contentType);
                this.getResourceLoaderCache().putResource(resourceName, libraryName, contentType, localePrefix, resourceMeta, loader);
                break;
            }
        }
        return resource;
    }

    protected ResourceMeta deriveResourceMeta(ResourceLoader resourceLoader, String resourceName, String libraryName, String localePrefix) {
        URL url;
        String resourceVersion = null;
        String libraryVersion = null;
        ResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".js")) {
            return "javax.faces.resource.Script";
        }
        if (resourceName.endsWith(".css")) {
            return "javax.faces.resource.Stylesheet";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
        if (resourceBasePath == null) {
            return;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        Object response = extContext.getResponse();
        HttpServletResponse httpServletResponse = ExternalContextUtils.getHttpServletResponse(response);
        if (httpServletResponse == null) {
            throw new IllegalStateException("Could not obtain an instance of HttpServletResponse.");
        }
        if (this.isResourceIdentifierExcluded(facesContext, resourceBasePath)) {
            httpServletResponse.setStatus(404);
            return;
        }
        String resourceName = null;
        if (resourceBasePath.startsWith("/javax.faces.resource")) {
            resourceName = resourceBasePath.substring("/javax.faces.resource".length() + 1);
            if (resourceBasePath != null && !ResourceValidationUtils.isValidResourceName(resourceName)) {
                httpServletResponse.setStatus(404);
                return;
            }
        } else {
            httpServletResponse.setStatus(404);
            return;
        }
        String libraryName = facesContext.getExternalContext().getRequestParameterMap().get("ln");
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            httpServletResponse.setStatus(404);
            return;
        }
        Resource resource = null;
        resource = libraryName != null ? facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName) : facesContext.getApplication().getResourceHandler().createResource(resourceName);
        if (resource == null) {
            httpServletResponse.setStatus(404);
            return;
        }
        if (!resource.userAgentNeedsUpdate(facesContext)) {
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.setContentType(this._getContentType(resource, facesContext.getExternalContext()));
        Map<String, String> headers = resource.getResponseHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpServletResponse.setHeader(entry.getKey(), entry.getValue());
        }
        extContext.setResponseBufferSize(this.getResourceBufferSize());
        try {
            InputStream in = resource.getInputStream();
            ServletOutputStream out = httpServletResponse.getOutputStream();
            byte[] buffer = new byte[this.getResourceBufferSize()];
            try {
                int count = ResourceHandlerImpl.pipeBytes(in, (OutputStream)out, buffer);
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.setContentLength(count);
                }
            }
            finally {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Error trying to load resource " + resourceName + " with library " + libraryName + " :" + e.getMessage(), e);
            }
            httpServletResponse.setStatus(404);
        }
    }

    private static int pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        int count = 0;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
            count += length;
        }
        return count;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        Boolean value = (Boolean)facesContext.getAttributes().get(IS_RESOURCE_REQUEST);
        if (value == null) {
            String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
            value = resourceBasePath != null && resourceBasePath.startsWith("/javax.faces.resource");
            facesContext.getAttributes().put(IS_RESOURCE_REQUEST, value);
        }
        return value;
    }

    protected String getLocalePrefixForLocateResource() {
        String localePrefix = null;
        FacesContext context = FacesContext.getCurrentInstance();
        boolean isResourceRequest = context.getApplication().getResourceHandler().isResourceRequest(context);
        if (isResourceRequest && (localePrefix = context.getExternalContext().getRequestParameterMap().get("loc")) != null) {
            if (!ResourceValidationUtils.isValidLocalePrefix(localePrefix)) {
                return null;
            }
            return localePrefix;
        }
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName) {
            Locale locale = null;
            locale = isResourceRequest || context.getViewRoot() == null ? context.getApplication().getViewHandler().calculateLocale(context) : context.getViewRoot().getLocale();
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, ClassUtils.getContextClassLoader());
                if (bundle != null) {
                    localePrefix = bundle.getString("javax.faces.resource.localePrefix");
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    protected boolean isResourceIdentifierExcluded(FacesContext context, String resourceIdentifier) {
        if (this._excludedResourceExtensions == null) {
            String value = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "javax.faces.RESOURCE_EXCLUDES", ".class .jsp .jspx .properties .xhtml");
            this._excludedResourceExtensions = StringUtils.splitShortString(value, ' ');
        }
        for (int i = 0; i < this._excludedResourceExtensions.length; ++i) {
            if (!resourceIdentifier.endsWith(this._excludedResourceExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean libraryExists(String libraryName) {
        String localePrefix = this.getLocalePrefixForLocateResource();
        String pathToLib = null;
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return false;
        }
        if (localePrefix != null) {
            pathToLib = localePrefix + '/' + libraryName;
            for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                if (!loader.libraryExists(pathToLib)) continue;
                return true;
            }
        }
        for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
            if (!loader.libraryExists(libraryName)) continue;
            return true;
        }
        return false;
    }

    public void setResourceHandlerSupport(ResourceHandlerSupport resourceHandlerSupport) {
        this._resourceHandlerSupport = resourceHandlerSupport;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        if (this._resourceHandlerSupport == null) {
            this._resourceHandlerSupport = new DefaultResourceHandlerSupport();
        }
        return this._resourceHandlerSupport;
    }

    private ResourceHandlerCache getResourceLoaderCache() {
        if (this._resourceHandlerCache == null) {
            this._resourceHandlerCache = new ResourceHandlerCache();
        }
        return this._resourceHandlerCache;
    }

    private String _getContentType(Resource resource, ExternalContext externalContext) {
        String resourceName;
        String contentType = resource.getContentType();
        if ((contentType == null || contentType.length() == 0) && (resourceName = this.getWrappedResourceName(resource)) != null) {
            contentType = externalContext.getMimeType(resourceName);
        }
        return contentType;
    }

    private String getWrappedResourceName(Resource resource) {
        String resourceName = resource.getResourceName();
        if (resourceName != null) {
            return resourceName;
        }
        if (resource instanceof ResourceWrapper) {
            return this.getWrappedResourceName(((ResourceWrapper)resource).getWrapped());
        }
        return null;
    }

    protected boolean isAllowSlashesLibraryName() {
        if (this._allowSlashLibraryName == null) {
            this._allowSlashLibraryName = WebConfigParamUtils.getBooleanInitParameter(FacesContext.getCurrentInstance().getExternalContext(), INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME, false);
        }
        return this._allowSlashLibraryName;
    }

    protected int getResourceBufferSize() {
        if (this._resourceBufferSize == -1) {
            this._resourceBufferSize = WebConfigParamUtils.getIntegerInitParameter(FacesContext.getCurrentInstance().getExternalContext(), INIT_PARAM_RESOURCE_BUFFER_SIZE, 2048);
        }
        return this._resourceBufferSize;
    }
}

