/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.el.ELManager;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PostConstructApplicationEvent;
import jakarta.faces.event.PreDestroyApplicationEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.myfaces.application.viewstate.StateUtils;
import org.apache.myfaces.cdi.util.BeanEntry;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.CdiAnnotationProviderExtension;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.push.EndpointImpl;
import org.apache.myfaces.push.WebsocketConfigurator;
import org.apache.myfaces.push.WebsocketFacesInit;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.StartupListener;
import org.apache.myfaces.webapp.WebConfigParamsLogger;

public class FacesInitializerImpl
implements FacesInitializer {
    private static final Logger log = Logger.getLogger(FacesInitializerImpl.class.getName());
    public static final String CDI_BEAN_MANAGER_INSTANCE = "oam.cdi.BEAN_MANAGER_INSTANCE";
    private static final String CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE = "jakarta.enterprise.inject.spi.BeanManager";
    public static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";
    public static final String INITIALIZED = "org.apache.myfaces.INITIALIZED";
    private static final byte FACES_INIT_PHASE_PREINIT = 0;
    private static final byte FACES_INIT_PHASE_POSTINIT = 1;
    private static final byte FACES_INIT_PHASE_PREDESTROY = 2;
    private static final byte FACES_INIT_PHASE_POSTDESTROY = 3;

    @Override
    public void initFaces(ServletContext servletContext) {
        if (Boolean.TRUE.equals(servletContext.getAttribute(INITIALIZED))) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("MyFaces already initialized");
            }
            return;
        }
        try {
            ResourceBundle.Control resourceBundleControl;
            Boolean mappingAdded;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Initializing MyFaces");
            }
            long start = System.currentTimeMillis();
            FacesContext facesContext = this.initStartupFacesContext(servletContext);
            ExternalContext externalContext = facesContext.getExternalContext();
            this.dispatchInitializationEvent(servletContext, 0);
            ServiceProviderFinder spf = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext);
            Map<String, List<String>> spfConfig = spf.calculateKnownServiceProviderMapInfo(externalContext, ServiceProviderFinder.KNOWN_SERVICES);
            if (spfConfig != null) {
                spf.initKnownServiceProviderMapInfo(externalContext, spfConfig);
            }
            if (!(WebConfigParamUtils.getBooleanInitParameter(externalContext, "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE", false) || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.FACES_SERVLET_FOUND")) != null && mappingAdded.booleanValue() || (mappingAdded = (Boolean)servletContext.getAttribute("org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET")) != null && mappingAdded.booleanValue())) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("No mappings of FacesServlet found. Abort initializing MyFaces.");
                }
                return;
            }
            this.initCDIIntegration(servletContext, externalContext);
            this.initContainerIntegration(servletContext, externalContext);
            ExternalSpecifications.isCDIAvailable(externalContext);
            ExternalSpecifications.isBeanValidationAvailable();
            String useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION");
            if ("false".equals(useEncryption)) {
                log.warning("org.apache.myfaces.USE_ENCRYPTION is set to false. This is unsecure and should only be used for local or intranet applications!");
            } else {
                StateUtils.initSecret(servletContext);
            }
            this._dispatchApplicationEvent(servletContext, PostConstructApplicationEvent.class);
            this.initWebsocketIntegration(servletContext, externalContext);
            WebConfigParamsLogger contextParamLogger = new WebConfigParamsLogger();
            contextParamLogger.logWebContextParams(facesContext);
            ViewPoolProcessor.initialize(facesContext);
            MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
            if (config.isAutomaticExtensionlessMapping()) {
                this.initAutomaticExtensionlessMapping(facesContext, servletContext);
            }
            if ((resourceBundleControl = config.getResourceBundleControl()) != null) {
                facesContext.getExternalContext().getApplicationMap().put("org.apache.myfaces.RESOURCE_BUNDLE_CONTROL", resourceBundleControl);
            }
            if (!facesContext.isProjectStage(ProjectStage.Production) && !facesContext.isProjectStage(ProjectStage.UnitTest)) {
                int i;
                ProjectStage projectStage = facesContext.getApplication().getProjectStage();
                StringBuilder message = new StringBuilder("\n\n");
                message.append("********************************************************************\n");
                message.append("*** WARNING: Apache MyFaces Core is running in ");
                message.append(projectStage.name().toUpperCase());
                message.append(" mode.");
                int length = projectStage.name().length();
                for (i = 0; i < 11 - length; ++i) {
                    message.append(' ');
                }
                message.append(" ***\n");
                message.append("***                                            ");
                for (i = 0; i < length; ++i) {
                    message.append('^');
                }
                for (i = 0; i < 18 - length; ++i) {
                    message.append(' ');
                }
                message.append("***\n");
                message.append("*** Do NOT deploy to your live server(s) without changing this.  ***\n");
                message.append("*** See Application#getProjectStage() for more information.      ***\n");
                message.append("********************************************************************\n");
                message.append("\n");
                log.log(Level.WARNING, message.toString());
            }
            this.cleanupAfterStartup(facesContext);
            this.dispatchInitializationEvent(servletContext, 1);
            this.destroyStartupFacesContext(facesContext);
            servletContext.setAttribute(INITIALIZED, Boolean.TRUE);
            log.log(Level.INFO, "MyFaces Core has started, it took [" + (System.currentTimeMillis() - start) + "] ms.");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error occured while initializing MyFaces: " + ex.getMessage(), ex);
        }
    }

    protected void cleanupAfterStartup(FacesContext facesContext) {
        BeanManager beanManager;
        CdiAnnotationProviderExtension extension;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (ExternalSpecifications.isCDIAvailable(externalContext) && (extension = CDIUtils.getOptional(beanManager = CDIUtils.getBeanManager(externalContext), CdiAnnotationProviderExtension.class)) != null) {
            extension.release();
        }
    }

    private void _dispatchApplicationEvent(ServletContext servletContext, Class<? extends SystemEvent> eventClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        application.publishEvent(facesContext, eventClass, Application.class, application);
    }

    @Override
    public void destroyFaces(ServletContext servletContext) {
        if (!Boolean.TRUE.equals(servletContext.getAttribute(INITIALIZED))) {
            return;
        }
        FacesContext facesContext = this.initShutdownFacesContext(servletContext);
        this.dispatchInitializationEvent(servletContext, 2);
        this._dispatchApplicationEvent(servletContext, PreDestroyApplicationEvent.class);
        this._callPreDestroyOnInjectedJSFArtifacts(facesContext);
        MetaRulesetImpl.clearMetadataTargetCache();
        if (facesContext.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.push")) {
            WebsocketFacesInit.destroy(facesContext.getExternalContext());
        }
        try {
            Class c = ClassUtils.classForName("jakarta.faces.component.UIViewParameter");
            Method m = c.getDeclaredMethod("releaseRenderer", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        this.destroyShutdownFacesContext(facesContext);
        FactoryFinder.releaseFactories();
        this.dispatchInitializationEvent(servletContext, 3);
        servletContext.removeAttribute(INITIALIZED);
    }

    protected RuntimeConfig buildConfiguration(ServletContext servletContext, ExternalContext externalContext, ExpressionFactory expressionFactory) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        runtimeConfig.setExpressionFactory(expressionFactory);
        new FacesConfigurator(externalContext).configure();
        this.validateFacesConfig(servletContext, externalContext);
        return runtimeConfig;
    }

    protected void validateFacesConfig(ServletContext servletContext, ExternalContext externalContext) {
        String validate = servletContext.getInitParameter("org.apache.myfaces.VALIDATE");
        if ("true".equals(validate) && log.isLoggable(Level.WARNING)) {
            List<String> warnings = FacesConfigValidator.validate(externalContext);
            for (String warning : warnings) {
                log.warning(warning);
            }
        }
    }

    protected static ExpressionFactory getUserDefinedExpressionFactory(ExternalContext externalContext) {
        String expressionFactoryClassName = MyfacesConfig.getCurrentInstance(externalContext).getExpressionFactory();
        if (StringUtils.isNotBlank(expressionFactoryClassName)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'.");
            }
            return FacesInitializerImpl.loadExpressionFactory(expressionFactoryClassName);
        }
        return null;
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        return FacesInitializerImpl.loadExpressionFactory(expressionFactoryClassName, true);
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName, boolean logMissing) {
        try {
            ClassLoader cl = ClassUtils.getContextClassLoader();
            if (cl == null) {
                cl = FacesInitializerImpl.class.getClassLoader();
            }
            Class<?> expressionFactoryClass = cl.loadClass(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'.", ex);
            }
            return null;
        }
    }

    @Override
    public FacesContext initStartupFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, true);
    }

    @Override
    public void destroyStartupFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    @Override
    public FacesContext initShutdownFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, false);
    }

    @Override
    public void destroyShutdownFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    private FacesContext _createFacesContext(ServletContext servletContext, boolean startup) {
        StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, startup);
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
        StartupFacesContextImpl facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, startup);
        UIViewRoot startupViewRoot = new UIViewRoot();
        startupViewRoot.setLocale(Locale.getDefault());
        ((FacesContext)facesContext).setViewRoot(startupViewRoot);
        return facesContext;
    }

    private void _releaseFacesContext(FacesContext facesContext) {
        if (facesContext != null) {
            facesContext.release();
        }
    }

    protected void initCDIIntegration(ServletContext servletContext, ExternalContext externalContext) {
        BeanManager beanManager = (BeanManager)servletContext.getAttribute(CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE);
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromJndi();
        }
        if (beanManager == null) {
            beanManager = this.lookupBeanManagerFromCDI();
        }
        if (beanManager != null) {
            externalContext.getApplicationMap().put(CDI_BEAN_MANAGER_INSTANCE, beanManager);
        }
    }

    private BeanManager lookupBeanManagerFromCDI() {
        try {
            return CDI.current().getBeanManager();
        }
        catch (Exception | LinkageError throwable) {
            return null;
        }
    }

    private BeanManager lookupBeanManagerFromJndi() {
        InitialContext initialContext2;
        BeanManager beanManager = null;
        try {
            initialContext2 = new InitialContext();
            beanManager = (BeanManager)initialContext2.lookup("java:comp/BeanManager");
        }
        catch (NamingException initialContext2) {
        }
        catch (NoClassDefFoundError initialContext2) {
            // empty catch block
        }
        if (beanManager == null) {
            try {
                initialContext2 = new InitialContext();
                beanManager = (BeanManager)initialContext2.lookup("java:comp/env/BeanManager");
            }
            catch (NamingException namingException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return beanManager;
    }

    public void _callPreDestroyOnInjectedJSFArtifacts(FacesContext facesContext) {
        InjectionProvider injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(facesContext.getExternalContext()).getInjectionProvider(facesContext.getExternalContext());
        List injectedBeanStorage = (List)facesContext.getExternalContext().getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
        if (injectedBeanStorage != null) {
            for (BeanEntry entry : injectedBeanStorage) {
                try {
                    injectionProvider.preDestroy(entry.getInstance(), entry.getCreationMetaData());
                }
                catch (InjectionProviderException ex) {
                    log.log(Level.INFO, "Exception on PreDestroy", ex);
                }
            }
            injectedBeanStorage.clear();
        }
    }

    protected void initWebsocketIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Boolean b = WebConfigParamUtils.getBooleanInitParameter(externalContext, "jakarta.faces.ENABLE_WEBSOCKET_ENDPOINT");
        if (Boolean.TRUE.equals(b)) {
            ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
            if (serverContainer == null) {
                log.log(Level.INFO, "f:websocket support is enabled but the WebSocket ServerContainer instance cannot be found in the current ServletContext.");
                return;
            }
            try {
                serverContainer.addEndpoint(ServerEndpointConfig.Builder.create(EndpointImpl.class, (String)"/jakarta.faces.push/{channel}").configurator((ServerEndpointConfig.Configurator)new WebsocketConfigurator(externalContext)).build());
                WebsocketFacesInit.init(externalContext);
                externalContext.getApplicationMap().put("org.apache.myfaces.push", "true");
            }
            catch (DeploymentException e) {
                log.log(Level.INFO, "Exception on initialize Websocket Endpoint: ", e);
            }
        }
    }

    protected void initAutomaticExtensionlessMapping(FacesContext facesContext, ServletContext servletContext) {
        ServletRegistration facesServletRegistration = (ServletRegistration)servletContext.getAttribute("org.apache.myfaces.FACES_SERVLET_SERVLETREGISTRATION");
        if (facesServletRegistration != null) {
            facesContext.getApplication().getViewHandler().getViews(facesContext, "/", ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME).forEach(s -> facesServletRegistration.addMapping((String)s));
        }
    }

    protected void initContainerIntegration(ServletContext servletContext, ExternalContext externalContext) {
        ExpressionFactory expressionFactory = FacesInitializerImpl.getUserDefinedExpressionFactory(externalContext);
        if (expressionFactory == null) {
            expressionFactory = ELManager.getExpressionFactory();
        }
        if (expressionFactory == null) {
            throw new FacesException("No " + ExpressionFactory.class.getName() + " implementation found. Please provide <context-param> in web.xml: org.apache.myfaces.EXPRESSION_FACTORY");
        }
        this.buildConfiguration(servletContext, externalContext, expressionFactory);
    }

    private void dispatchInitializationEvent(ServletContext context, int operation) {
        List pluginEntries;
        if (operation == 0 && !this.loadFacesInitPluginsViaServiceLoader(context)) {
            this.loadFacesInitViaContextParam(context);
        }
        if ((pluginEntries = (List)context.getAttribute("org.apache.myfaces.FACES_INIT_PLUGINS")) == null) {
            return;
        }
        for (StartupListener initializer : pluginEntries) {
            log.info("Processing plugin");
            switch (operation) {
                case 0: {
                    initializer.preInit(context);
                    break;
                }
                case 1: {
                    initializer.postInit(context);
                    break;
                }
                case 2: {
                    initializer.preDestroy(context);
                    break;
                }
                case 3: {
                    initializer.postDestroy(context);
                    break;
                }
            }
        }
        log.info("Processing MyFaces plugins done");
    }

    private boolean loadFacesInitPluginsViaServiceLoader(ServletContext servletContext) {
        ServiceLoader<StartupListener> loader = ServiceLoader.load(StartupListener.class, ClassUtils.getContextClassLoader());
        Iterator<StartupListener> it = loader.iterator();
        if (!it.hasNext()) {
            return false;
        }
        LinkedList<StartupListener> listeners = new LinkedList<StartupListener>();
        while (it.hasNext()) {
            listeners.add(it.next());
        }
        servletContext.setAttribute("org.apache.myfaces.FACES_INIT_PLUGINS", listeners);
        return true;
    }

    private void loadFacesInitViaContextParam(ServletContext servletContext) {
        String plugins = servletContext.getInitParameter("org.apache.myfaces.FACES_INIT_PLUGINS");
        if (plugins == null) {
            return;
        }
        log.info("MyFaces Plugins found");
        String[] pluginEntries = plugins.split(",");
        ArrayList<StartupListener> listeners = new ArrayList<StartupListener>(pluginEntries.length);
        for (String pluginEntry : pluginEntries) {
            try {
                Class<?> pluginClass = ClassUtils.getContextClassLoader().loadClass(pluginEntry);
                if (pluginClass == null) {
                    pluginClass = this.getClass().getClassLoader().loadClass(pluginEntry);
                }
                listeners.add((StartupListener)pluginClass.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        servletContext.setAttribute("org.apache.myfaces.FACES_INIT_PLUGINS", listeners);
    }
}

