/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.persistence.EntityManager;
import org.apache.myfaces.extensions.cdi.jpa.api.TransactionScoped;
import org.apache.myfaces.extensions.cdi.jpa.api.Transactional;
import org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context.TransactionBeanEntry;
import org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context.TransactionBeanStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class TransactionContext
implements Context {
    public <T> T get(Contextual<T> component) {
        Map<Contextual, TransactionBeanEntry> transactionBeanEntryMap = this.getTransactionBeanEntryMap();
        if (transactionBeanEntryMap == null) {
            return null;
        }
        TransactionBeanEntry transactionBeanEntry = transactionBeanEntryMap.get(component);
        if (transactionBeanEntry != null) {
            this.checkTransactionBeanEntry(transactionBeanEntry);
            return transactionBeanEntry.getContextualInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        Map<Contextual, TransactionBeanEntry> transactionBeanEntryMap;
        if (TransactionBeanStorage.getStorage().getActiveTransactionContext() == null) {
            TransactionBeanStorage.activateNewStorage();
        }
        if ((transactionBeanEntryMap = this.getTransactionBeanEntryMap()) == null) {
            throw new ContextNotActiveException("Not accessed within a transactional method - use @" + Transactional.class.getName());
        }
        TransactionBeanEntry<Object> transactionBeanEntry = transactionBeanEntryMap.get(component);
        if (transactionBeanEntry != null) {
            this.checkTransactionBeanEntry(transactionBeanEntry);
            return transactionBeanEntry.getContextualInstance();
        }
        Object instance = component.create(creationalContext);
        transactionBeanEntry = new TransactionBeanEntry<Object>(component, instance, creationalContext);
        transactionBeanEntryMap.put(component, transactionBeanEntry);
        this.checkTransactionBeanEntry(transactionBeanEntry);
        return (T)instance;
    }

    private void checkTransactionBeanEntry(TransactionBeanEntry<?> transactionBeanEntry) {
        if (!(transactionBeanEntry.getContextualInstance() instanceof EntityManager)) {
            return;
        }
        String activeTransactionKey = TransactionBeanStorage.getStorage().getActiveTransactionKey();
        for (Annotation qualifier : transactionBeanEntry.getQualifiers()) {
            if (!qualifier.annotationType().getName().endsWith(activeTransactionKey)) continue;
            return;
        }
        throw new IllegalStateException("Transaction qualifier of the intercepted bean or method and the injected entity-manager has to be the same. Active transaction qualifier: " + activeTransactionKey + " qualifier/s of the entity-manager: " + this.extractQualifiers(transactionBeanEntry));
    }

    private String extractQualifiers(TransactionBeanEntry<?> transactionBeanEntry) {
        StringBuilder result = new StringBuilder();
        for (Annotation annotation : transactionBeanEntry.getQualifiers()) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append(annotation.annotationType().getName());
        }
        return result.toString();
    }

    private Map<Contextual, TransactionBeanEntry> getTransactionBeanEntryMap() {
        TransactionBeanStorage transactionBeanStorage = TransactionBeanStorage.getStorage();
        if (transactionBeanStorage != null) {
            transactionBeanStorage.activateTransactionScope(null);
            return transactionBeanStorage.getActiveTransactionContext();
        }
        return null;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public boolean isActive() {
        return TransactionBeanStorage.getStorage() != null;
    }
}

