/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoter;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtractedViewConfigDefinitionEntry
implements EditableViewConfigDescriptor {
    static final String ROOT_PATH = "/";
    static final String DEFAULT_EXTENSION = "xhtml";
    protected static final String DEFAULT_PAGE_NAME = "";
    private static final String NOT_IMPLEMENTED_MESSAGE = "not implemented";
    private List<Class<? extends Annotation>> foundAndBlockedMetaDataTypes = new ArrayList<Class<? extends Annotation>>();
    private List<Class<? extends AccessDecisionVoter>> foundVoters = new ArrayList<Class<? extends AccessDecisionVoter>>();
    private Class<? extends ViewConfig> errorView = null;
    private List<Annotation> viewMetaDataList = new ArrayList<Annotation>();
    protected Class<? extends ViewConfig> viewDefinitionClass;
    protected String basePath = "/";
    private Map<String, String> simpleClassNameToPathMapping = new HashMap<String, String>();
    protected String pageName = "";
    private String extension = "xhtml";
    private Page.NavigationMode navigationMode = null;
    private Page.ViewParameterMode viewParameterMode = null;

    public ExtractedViewConfigDefinitionEntry(Class<? extends ViewConfig> viewDefinitionClass) {
        this.viewDefinitionClass = viewDefinitionClass;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isKnownNavigationMode() {
        return this.navigationMode != null;
    }

    public boolean isKnownViewParameterMode() {
        return this.viewParameterMode != null;
    }

    public Page.NavigationMode getNavigationMode() {
        if (this.navigationMode == null) {
            return Page.NavigationMode.DEFAULT;
        }
        return this.navigationMode;
    }

    @Override
    public Page.ViewParameterMode getViewParameterMode() {
        if (this.viewParameterMode == null) {
            return Page.ViewParameterMode.DEFAULT;
        }
        return this.viewParameterMode;
    }

    @Override
    public Class<? extends ViewConfig> getErrorView() {
        return this.errorView;
    }

    public List<Class<? extends Annotation>> getFoundAndBlockedMetaDataTypes() {
        return this.foundAndBlockedMetaDataTypes;
    }

    public void addAccessDecisionVoters(Class<? extends AccessDecisionVoter>[] accessDecisionVoterClasses) {
        Collections.addAll(this.foundVoters, accessDecisionVoterClasses);
    }

    public void setErrorView(Class<? extends ViewConfig> errorViewClass) {
        this.errorView = errorViewClass;
    }

    public void setExtension(String fileExtension) {
        this.extension = fileExtension;
    }

    public void setBasePath(String currentBasePath) {
        this.basePath = currentBasePath;
    }

    public void setNavigationMode(Page.NavigationMode navigationMode) {
        this.navigationMode = navigationMode;
    }

    public void setViewParameterMode(Page.ViewParameterMode viewParameterMode) {
        this.viewParameterMode = viewParameterMode;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void addMetaData(Collection<Annotation> annotations) {
        this.viewMetaDataList.addAll(annotations);
    }

    public void setSimpleClassNameToPathMapping(String simpleName, String currentBasePath) {
        this.simpleClassNameToPathMapping.put(simpleName, currentBasePath);
    }

    public List<Annotation> getMetaData() {
        return this.viewMetaDataList;
    }

    public String getViewId() {
        String className;
        StringBuilder viewId = new StringBuilder(this.basePath);
        if (this.pageName.equals(DEFAULT_PAGE_NAME)) {
            className = this.getNestedConfigAsPath();
            className = this.createPageName(className);
            viewId.append(className);
        } else if (!this.simpleClassNameToPathMapping.isEmpty()) {
            className = this.viewDefinitionClass.getName();
            if (ROOT_PATH.endsWith(this.basePath) && this.simpleClassNameToPathMapping.size() == 1) {
                className = ROOT_PATH + this.simpleClassNameToPathMapping.get(this.viewDefinitionClass.getSimpleName()) + ROOT_PATH;
            } else {
                className = className.substring(className.lastIndexOf(46) + 1);
                className = this.convertToPathSyntax(className, this.simpleClassNameToPathMapping);
                className = this.createPageName(className);
                className = className.substring(0, className.lastIndexOf(47) + 1);
            }
            className = className + this.pageName;
            viewId.append(className);
        } else if (!this.pageName.equals(DEFAULT_PAGE_NAME) && this.viewDefinitionClass.getName().contains("$")) {
            className = this.getNestedConfigAsPath();
            viewId.append(className.substring(0, className.lastIndexOf(ROOT_PATH) + 1)).append(this.pageName);
        } else {
            viewId.append(this.pageName);
        }
        viewId.append(".");
        viewId.append(this.extension);
        String result = viewId.toString();
        if (result.startsWith(".")) {
            result = result.startsWith("./") ? result.substring(1) : ROOT_PATH + result.substring(1);
        }
        result = this.ensureValidViewIds(result);
        return result;
    }

    private String getNestedConfigAsPath() {
        String className = this.viewDefinitionClass.getName();
        if (className.contains("$") && ".".equals(this.basePath)) {
            className = className.substring(className.lastIndexOf(46) + 1);
            className = this.convertToPathSyntax(className, this.simpleClassNameToPathMapping);
        } else {
            className = className.contains("$") ? className.substring(className.lastIndexOf(36) + 1) : className.substring(className.lastIndexOf(46) + 1);
        }
        return className;
    }

    protected String createPageName(String className) {
        className = className.substring(0, 1).toLowerCase() + className.substring(1);
        return className;
    }

    public Class<? extends ViewConfig> getViewConfig() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    public <T extends Annotation> List<T> getMetaData(Class<T> target) {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    private String ensureValidViewIds(String result) {
        if (!result.startsWith(ROOT_PATH)) {
            result = ROOT_PATH + result;
        }
        return result.replace("///", ROOT_PATH).replace("//", ROOT_PATH);
    }

    private String convertToPathSyntax(String className, Map<String, String> simpleClassNameToPathMapping) {
        String[] parts = className.split("\\$");
        StringBuilder path = new StringBuilder();
        for (String part : parts) {
            if (simpleClassNameToPathMapping.containsKey(part)) {
                path.append(simpleClassNameToPathMapping.get(part));
            } else {
                path.append(part.substring(0, 1).toLowerCase());
                path.append(part.substring(1));
            }
            path.append(ROOT_PATH);
        }
        String result = path.toString();
        return result.substring(0, result.length() - 1);
    }

    public List<Class<? extends AccessDecisionVoter>> getAccessDecisionVoters() {
        return Collections.unmodifiableList(this.foundVoters);
    }

    @Override
    public void addPageBean(Class pageBeanClass) {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public void invokeInitViewMethods() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public void invokePrePageActionMethods() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public void invokePreRenderViewMethods() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public void invokePostRenderViewMethods() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    public List<PageBeanDescriptor> getPageBeanDescriptors() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public void setPartialViewConfig(boolean partialMode) {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    public boolean isPartialViewConfig() {
        throw new IllegalStateException(NOT_IMPLEMENTED_MESSAGE);
    }

    public void blockMetaData(Class<? extends Annotation> metaDataClass) {
        this.foundAndBlockedMetaDataTypes.add(metaDataClass);
    }
}

