/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.bv.api;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLevelConstraintValidator<A extends Annotation, T>
implements ConstraintValidator<A, T>,
Serializable {
    protected A constraint;

    public void initialize(A constraint) {
        this.constraint = constraint;
    }

    public boolean isValid(T instance, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = this.isValidInstance(instance, constraintValidatorContext);
        if (!valid) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(this.createMessage(this.getInvalidValue(), this.getMessageDescriptor())).addConstraintViolation();
        }
        return valid;
    }

    protected String createMessage(Serializable invalidValue, String messageDescriptor) {
        return invalidValue + "$org.apache.myfaces.extensions.cdi$" + messageDescriptor;
    }

    protected String getMessageDescriptor() {
        try {
            Method method = this.constraint.annotationType().getDeclaredMethod("message", new Class[0]);
            return (String)method.invoke(this.constraint, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    protected abstract boolean isValidInstance(T var1, ConstraintValidatorContext var2);

    protected abstract Serializable getInvalidValue();
}

