/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.util;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDeniedException;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolation;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolationHandler;
import org.apache.myfaces.extensions.cdi.core.api.tools.DefaultAnnotation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.Jsf;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayload;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessageSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class SecurityUtils {
    private static final Jsf JSF_QUALIFIER = (Jsf)DefaultAnnotation.of(Jsf.class);

    private SecurityUtils() {
    }

    public static Class<? extends ViewConfig> handleSecurityViolationWithoutNavigation(RuntimeException runtimeException) {
        return SecurityUtils.tryToHandleSecurityViolation(runtimeException, false);
    }

    public static void tryToHandleSecurityViolation(RuntimeException runtimeException) {
        SecurityUtils.tryToHandleSecurityViolation(runtimeException, true);
    }

    private static Class<? extends ViewConfig> tryToHandleSecurityViolation(RuntimeException runtimeException, boolean allowNavigation) {
        ViewConfigDescriptor errorPageDescriptor;
        AccessDeniedException exception = SecurityUtils.extractException(runtimeException);
        if (exception == null) {
            throw runtimeException;
        }
        Class errorView = null;
        Class inlineErrorView = exception.getErrorView();
        if (inlineErrorView != null && !DefaultErrorView.class.getName().equals(inlineErrorView.getName())) {
            errorView = inlineErrorView;
        }
        if (errorView == null && (errorPageDescriptor = ViewConfigCache.getDefaultErrorViewConfigDescriptor()) != null) {
            errorView = errorPageDescriptor.getViewConfig();
        }
        if (errorView == null) {
            throw exception;
        }
        SecurityUtils.processApplicationSecurityException(exception, errorView, allowNavigation);
        return errorView;
    }

    private static AccessDeniedException extractException(Throwable exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof AccessDeniedException) {
            return (AccessDeniedException)exception;
        }
        return SecurityUtils.extractException(exception.getCause());
    }

    private static void processApplicationSecurityException(AccessDeniedException exception, Class<? extends ViewConfig> errorPage, boolean allowNavigation) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SecurityViolationHandler securityViolationHandler = (SecurityViolationHandler)CodiUtils.getContextualReferenceByClass(SecurityViolationHandler.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (securityViolationHandler != null) {
            securityViolationHandler.processSecurityViolations(exception.getViolations());
        } else {
            SecurityUtils.addViolationsAsMessage(exception.getViolations());
        }
        if (allowNavigation) {
            facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, null, errorPage.getName());
        }
    }

    private static void addViolationsAsMessage(Set<SecurityViolation> violations) {
        MessageContext messageContext = (MessageContext)CodiUtils.getContextualReferenceByClass(MessageContext.class, (boolean)true, (Annotation[])new Annotation[]{JSF_QUALIFIER});
        if (messageContext == null) {
            return;
        }
        for (SecurityViolation violation : violations) {
            messageContext.message().text(violation.getReason()).payload(new MessagePayload[]{MessageSeverity.ERROR}).add();
        }
    }
}

