/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.config;

import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfiguredValueDescriptor;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.config.AbstractConfiguredValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
@InvocationOrder(value=100)
public class SystemPropertyResolver
extends AbstractConfiguredValueResolver {
    private static final String BASE_NAME = "org.apache.myfaces.extensions.cdi.";

    public <K, T> List<T> resolveInstances(ConfiguredValueDescriptor<K, T> descriptor) {
        String configuredValue;
        String key = "" + descriptor.getKey();
        if (!key.contains(".")) {
            key = BASE_NAME + key;
        }
        if ((configuredValue = System.getProperty(key)) == null) {
            return Collections.emptyList();
        }
        if (!String.class.isAssignableFrom(descriptor.getTargetType())) {
            if (Boolean.class.isAssignableFrom(descriptor.getTargetType())) {
                this.add(descriptor.getTargetType().cast(Boolean.parseBoolean(configuredValue)));
            } else if (Integer.class.isAssignableFrom(descriptor.getTargetType())) {
                this.add(descriptor.getTargetType().cast(Integer.parseInt(configuredValue)));
            } else {
                Class targetClass = ClassUtils.tryToLoadClassForName((String)configuredValue, (Class)descriptor.getTargetType());
                if (targetClass != null) {
                    this.add(targetClass);
                }
            }
        } else {
            this.add(configuredValue);
        }
        return this.getConfiguredValues(descriptor.getTargetType());
    }
}

