/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.viewController;

import org.apache.myfaces.orchestra.annotation.AnnotationInfo;
import org.apache.myfaces.orchestra.annotation.AnnotationInfoManager;

/**
 * Lookup a bean configured using the ViewController annotation which is responsible
 * for the given <code>viewId</code>.
 * 
 * @see org.apache.myfaces.orchestra.viewController.annotations.ViewController
 */
public class AnnotationsViewControllerNameMapper implements ViewControllerNameMapper
{
    private final AnnotationInfoManager annotationInfoManager;
    
    public AnnotationsViewControllerNameMapper(AnnotationInfoManager annotationInfoManager)
    {
        this.annotationInfoManager = annotationInfoManager;
    }

    public String mapViewId(String viewId)
    {
        AnnotationInfo annotationsInfo = annotationInfoManager.getAnnotationInfoByViewId(viewId);
        if (annotationsInfo != null)
        {
            return annotationsInfo.getBeanName();
        }

        return null;
    }
}
