/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationAware;
import org.apache.myfaces.orchestra.conversation.ConversationBindingEvent;
import org.apache.myfaces.orchestra.conversation.ConversationBindingListener;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationFactory;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.CurrentConversationAdvice;
import org.apache.myfaces.orchestra.conversation.spring.OrchestraAdvisorBeanPostProcessor;
import org.apache.myfaces.orchestra.conversation.spring.ScopedBeanTargetSource;
import org.apache.myfaces.orchestra.conversation.spring.SimpleAdvisor;
import org.apache.myfaces.orchestra.conversation.spring._SpringUtils;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.springframework.aop.Advisor;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractSpringOrchestraScope
implements ConversationFactory,
Scope,
BeanFactoryAware,
ApplicationContextAware {
    private static final Advice[] NO_ADVICES = new Advice[0];
    private static final String POST_PROCESSOR_BEAN_NAME = AbstractSpringOrchestraScope.class.getName() + "_BeanPostProcessor";
    private final Log log = LogFactory.getLog(AbstractSpringOrchestraScope.class);
    private ConfigurableApplicationContext applicationContext;
    private Advice[] advices;
    private boolean autoProxy = true;

    public void setAdvices(Advice[] advices) {
        this.advices = advices;
    }

    protected Advice[] getAdvices() {
        return this.advices;
    }

    public void setAutoProxy(boolean state) {
        this.autoProxy = state;
    }

    public String getConversationId() {
        ConversationManager manager = ConversationManager.getInstance();
        ConversationContext ctx = manager.getCurrentConversationContext();
        if (ctx != null) {
            return Long.toString(ctx.getId(), 10);
        }
        return null;
    }

    public Object get(String name, ObjectFactory objectFactory) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Method get called for bean " + name));
        }
        if (_SpringUtils.isModifiedBeanName(name)) {
            try {
                String originalBeanName = _SpringUtils.getOriginalBeanName(name);
                String conversationName = this.getConversationNameForBean(name);
                return this.getRealBean(conversationName, originalBeanName, objectFactory);
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Exception while accessing bean '" + name + "'"));
                throw e;
            }
        }
        if (!this.autoProxy) {
            String conversationName = this.getConversationNameForBean(name);
            return this.getRealBean(conversationName, name, objectFactory);
        }
        return this.getProxy(name, objectFactory);
    }

    protected Object getProxy(String beanName, ObjectFactory objectFactory) {
        FrameworkAdapter fa;
        Object proxy;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getProxy called for bean " + beanName));
        }
        BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
        String conversationName = this.getConversationNameForBean(beanName);
        HashMap proxies = (HashMap)beanDefinition.getAttribute(ScopedBeanTargetSource.class.getName());
        if (proxies == null) {
            proxies = new HashMap();
            beanDefinition.setAttribute(ScopedBeanTargetSource.class.getName(), proxies);
        }
        if ((proxy = proxies.get(conversationName)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getProxy: creating proxy for " + beanName));
            }
            ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
            proxy = _SpringUtils.newProxy(this, conversationName, beanName, objectFactory, (BeanFactory)beanFactory);
            proxies.put(conversationName, proxy);
        }
        if ((fa = FrameworkAdapter.getCurrentInstance()) != null && fa.containsRequestAttribute("javax.portlet.orchestra.phase")) {
            fa.setRequestAttribute(beanName, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getRealBean(String conversationName, String beanName, ObjectFactory objectFactory) {
        Conversation conversation;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getRealBean called for bean " + beanName));
        }
        ConversationManager manager = ConversationManager.getInstance();
        Object object = manager;
        synchronized (object) {
            conversation = manager.getConversation(conversationName);
            if (conversation == null) {
                conversation = manager.startConversation(conversationName, this);
            } else {
                this.assertSameScope(beanName, conversation);
            }
        }
        this.notifyAccessConversation(conversation);
        object = conversation;
        synchronized (object) {
            if (!conversation.hasAttribute(beanName)) {
                Object value;
                BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
                beanDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
                try {
                    value = objectFactory.getObject();
                }
                catch (AopConfigException e) {
                    throw new IllegalStateException("Unable to create Orchestra proxy for bean " + beanName, e);
                }
                conversation.setAttribute(beanName, value);
                if (value instanceof ConversationAware) {
                    ((ConversationAware)value).setConversation(conversation);
                }
            }
        }
        return conversation.getAttribute(beanName);
    }

    protected void assertSameScope(String beanName, Conversation conversation) {
        if (conversation.getFactory() != this) {
            throw new IllegalArgumentException("Inconsistent scope and conversation name detected for bean " + beanName);
        }
    }

    protected void notifyAccessConversation(Conversation conversation) {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public void defineBeanPostProcessors(ConfigurableListableBeanFactory cbf) throws BeansException {
        if (!cbf.containsSingleton(POST_PROCESSOR_BEAN_NAME)) {
            OrchestraAdvisorBeanPostProcessor processor = new OrchestraAdvisorBeanPostProcessor(this.applicationContext);
            cbf.registerSingleton(POST_PROCESSOR_BEAN_NAME, (Object)processor);
        }
    }

    protected Conversation getConversationForBean(String beanDefName) {
        ConversationManager manager = ConversationManager.getInstance();
        String conversationName = this.getConversationNameForBean(beanDefName);
        Conversation conversation = manager.getConversation(conversationName);
        return conversation;
    }

    public String getConversationNameForBean(String beanName) {
        String convName;
        if (this.applicationContext == null) {
            throw new IllegalStateException("Null application context");
        }
        BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
        if (ScopedProxyFactoryBean.class.getName().equals(beanDefinition.getBeanClassName())) {
            beanName = _SpringUtils.getModifiedBeanName(beanName);
            beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
        }
        if ((convName = this.getExplicitConversationName(beanDefinition)) == null) {
            convName = _SpringUtils.getOriginalBeanName(beanName);
        }
        return convName;
    }

    protected String getExplicitConversationName(BeanDefinition beanDef) {
        String attr = (String)beanDef.getAttribute("org.apache.myfaces.orchestra.spring.conversationName");
        return attr;
    }

    protected String buildBeanName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.indexOf(46);
        if (pos < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    public Object remove(String name) {
        throw new UnsupportedOperationException();
    }

    public void registerDestructionCallback(String name, final Runnable runnable) {
        Conversation conversation;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("registerDestructionCallback for [" + name + "]"));
        }
        if ((conversation = this.getConversationForBean(name)) == null) {
            throw new IllegalStateException("No conversation for bean [" + name + "]");
        }
        if (runnable == null) {
            throw new IllegalStateException("No runnable object for bean [" + name + "]");
        }
        conversation.setAttribute(runnable.getClass().getName() + "@" + System.identityHashCode(runnable), new ConversationBindingListener(){

            public void valueBound(ConversationBindingEvent event) {
            }

            public void valueUnbound(ConversationBindingEvent event) {
                runnable.run();
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("a ConfigurableApplicationContext is required");
        }
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.defineBeanPostProcessors(this.applicationContext.getBeanFactory());
    }

    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    Advisor[] getAdvisors(Conversation conversation, String beanName) {
        Advice[] advices = this.getAdvices();
        if (advices == null || advices.length == 0) {
            advices = NO_ADVICES;
        }
        int len = advices.length + 1;
        Advisor[] advisors = new Advisor[len];
        CurrentConversationAdvice currConvAdvice = new CurrentConversationAdvice(conversation, beanName);
        advisors[0] = new SimpleAdvisor((Advice)currConvAdvice);
        for (int i = 0; i < advices.length; ++i) {
            advisors[i + 1] = new SimpleAdvisor(advices[i]);
        }
        return advisors;
    }

    Object createProxyFor(Conversation conversation, Object instance) {
        if (instance instanceof SpringProxy) {
            return instance;
        }
        String beanName = "dummy$" + instance.getClass().getName();
        ProxyFactory proxyFactory = new ProxyFactory(instance);
        proxyFactory.setProxyTargetClass(true);
        Advisor[] advisors = this.getAdvisors(conversation, beanName);
        for (int i = 0; i < advisors.length; ++i) {
            proxyFactory.addAdvisor(advisors[i]);
        }
        proxyFactory.addInterface(SpringProxy.class);
        return proxyFactory.getProxy(instance.getClass().getClassLoader());
    }
}

