/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.conversation;

// Note that if this bean does NOT implement any interfaces, then CGLIB is used to
// generate proxies for it. If it implements one or more interfaces, then the
// java.util.proxy module is used to generate proxies for it instead, unless
// CGLIB is explicitly forced to be used.
//
// Presumably Spring is assuming that the interface it implements is a
// "business interface" that users of the bean are coded to.
//
// However the type of proxy has interesting side-effects: a CGLIB proxy can
// itself be proxied by CGLIB. However a JDK proxy cannot; that generates a
// <i>final</i> class which CGLIB simply cannot generate a subclass of.
public class SimpleBean implements SimpleInterface, ConversationAware
{
    private String data;

    SimpleBean[] thisRefHolder;
    SimpleBean thisRef;
    
    int conversationAwareCount = 0;
    
    public SimpleBean()
    {
    }

    public SimpleBean getThis()
    {
        thisRefHolder = new SimpleBean[1];
        thisRefHolder[0] = this;
        thisRef = this;
        return this;
    }
    
    public SimpleBean getThisRef()
    {
        return thisRef;
    }

    public SimpleBean[] getThisRefHolder()
    {
        return thisRefHolder;
    }

    public String getData()
    {
        return data;
    }

    public void setData(String data)
    {
        this.data = data;
    }

    public void transactionalMethod()
    {
    }

    public void setConversation(Conversation conversation)
    {
        ++conversationAwareCount;
    }
    
    public int getConversationAwareCount()
    {
        return conversationAwareCount;
    }

    public void doSomething()
    {
    }
    
    public void callback(Runnable callback)
    {
        callback.run();
    }
    
    public Object bindToCurrentConversation(Object target)
    {
        Conversation conv = Conversation.getCurrentInstance();
        Object oProxy = conv.bind(target);
        return oProxy;
    }
}
