/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import javax.swing.BoundedRangeModel;
import org.apache.myfaces.tobago.component.Visual;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUIProgress
extends UIOutput
implements Visual,
ComponentSystemEventListener,
ClientBehaviorHolder {
    private double rangeValue;
    private double rangeMax;

    public double getRangeValue() {
        return this.rangeValue;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PreRenderComponentEvent) {
            Object model = this.getValue();
            if (model instanceof BoundedRangeModel) {
                BoundedRangeModel m = (BoundedRangeModel)model;
                this.rangeValue = m.getValue();
                this.rangeMax = m.getMaximum();
                int min = m.getMinimum();
                if (min != 0) {
                    this.rangeValue -= (double)min;
                    this.rangeMax -= (double)min;
                }
            } else {
                if (model instanceof Number) {
                    this.rangeValue = ((Number)model).doubleValue();
                } else if (model != null) {
                    this.rangeValue = Double.parseDouble("" + model);
                }
                this.rangeMax = this.getMax() != null ? this.getMax() : 1.0;
                if (this.rangeValue > this.rangeMax) {
                    this.rangeValue = this.rangeMax;
                }
            }
        }
    }

    public abstract Double getMax();
}

