/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.SortedColumn;
import org.apache.myfaces.tobago.util.MessageUtils;
import org.apache.myfaces.tobago.util.ValueExpressionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private SortingUtils() {
    }

    public static void sort(AbstractUISheet sheet, Comparator comparator) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object value = sheet.getValue();
        Object data = value instanceof DataModel ? ((DataModel)value).getWrappedData() : value;
        SheetState sheetState = sheet.getSheetState(facesContext);
        boolean success = false;
        if (sheetState.getToBeSortedLevel() > 0) {
            UIColumn column = null;
            try {
                for (int i = sheetState.getToBeSortedLevel() - 1; i >= 0; --i) {
                    SortedColumn sortedColumn = sheetState.getSortedColumnList().get(i);
                    column = (UIColumn)sheet.findComponent(sortedColumn.getId());
                    if (column != null) {
                        success = SortingUtils.sort(facesContext, sheet, data, column, sortedColumn.isAscending(), sheetState, comparator);
                        continue;
                    }
                    LOG.error("No column to sort found, sorterId = '{}'!", (Object)sortedColumn.getId());
                    SortingUtils.addNotSortableMessage(facesContext, null);
                }
            }
            catch (Exception e) {
                LOG.error("Error while extracting sortMethod :" + e.getMessage(), (Throwable)e);
                SortingUtils.addNotSortableMessage(facesContext, column);
            }
        } else {
            LOG.debug("Not to be sorted!");
        }
        if (!success) {
            sheetState.resetSortState();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean sort(FacesContext facesContext, AbstractUISheet sheet, Object data, UIColumn column, boolean ascending, SheetState sheetState, Comparator comparator) {
        ArrayList<void> selectedDataRows;
        ValueExpressionComparator actualComparator;
        block17: {
            Object expression;
            block18: {
                block16: {
                    if (!(data instanceof List) && !(data instanceof Object[])) break block16;
                    try {
                        UIComponent child = SortingUtils.getFirstSortableChild(column.getChildren());
                        if (child == null) {
                            LOG.error("No sorting performed. Value is not instanceof List or Object[]!");
                            SortingUtils.addNotSortableMessage(facesContext, column);
                            return false;
                        }
                        String string = (child instanceof AbstractUICommand ? Attributes.label : Attributes.value).getName();
                        expression = child.getValueExpression(string);
                        if (expression == null) {
                            LOG.error("No sorting performed, because no expression found for attribute '{}' in component '{}' with id='{}'! You may check the type of the component!", new Object[]{string, child.getClass().getName(), child.getClientId()});
                            SortingUtils.addNotSortableMessage(facesContext, column);
                            return false;
                        }
                        String var = sheet.getVar();
                        if (var == null) {
                            LOG.error("No sorting performed. Property var of sheet is not set!");
                            SortingUtils.addNotSortableMessage(facesContext, column);
                            return false;
                        }
                        actualComparator = new ValueExpressionComparator(facesContext, var, (ValueExpression)expression, !ascending, comparator);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    selectedDataRows = null;
                    if (sheetState.getSelectedRows().size() <= 0) break block17;
                    selectedDataRows = new ArrayList<void>(sheetState.getSelectedRows().size());
                    expression = sheetState.getSelectedRows().iterator();
                    break block18;
                }
                LOG.warn("Sorting not supported for type '{}'.", (Object)(data != null ? data.getClass().toString() : "null"));
                SortingUtils.addNotSortableMessage(facesContext, column);
                return false;
            }
            while (expression.hasNext()) {
                void var9_13;
                Integer index = (Integer)expression.next();
                if (data instanceof List) {
                    Object e = ((List)data).get(index);
                } else {
                    Object object = ((Object[])data)[index];
                }
                selectedDataRows.add(var9_13);
            }
        }
        if (data instanceof List) {
            Collections.sort((List)data, actualComparator);
        } else {
            Arrays.sort((Object[])data, actualComparator);
        }
        if (selectedDataRows != null) {
            sheetState.getSelectedRows().clear();
            for (Object dataRow : selectedDataRows) {
                int i;
                int index = -1;
                if (data instanceof List) {
                    for (i = 0; i < ((List)data).size() && index < 0; ++i) {
                        if (dataRow != ((List)data).get(i)) continue;
                        index = i;
                    }
                } else {
                    for (i = 0; i < ((Object[])data).length && index < 0; ++i) {
                        if (dataRow != ((Object[])data)[i]) continue;
                        index = i;
                    }
                }
                if (index < 0) continue;
                sheetState.getSelectedRows().add(index);
            }
        }
        return true;
    }

    private static void addNotSortableMessage(FacesContext facesContext, UIColumn column) {
        if (column != null) {
            String label = MessageUtils.getLabel(facesContext, (UIComponent)column);
            facesContext.addMessage(column.getClientId(facesContext), MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_WARN, "org.apache.myfaces.tobago.UISheet.SORTING_COL", label));
        } else {
            facesContext.addMessage(null, MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_WARN, "org.apache.myfaces.tobago.UISheet.SORTING", new Object[0]));
        }
    }

    private static UIComponent getFirstSortableChild(List<UIComponent> children) {
        UIComponent result = null;
        Iterator<UIComponent> iterator = children.iterator();
        while (iterator.hasNext()) {
            UIComponent child;
            result = child = iterator.next();
            if (child instanceof UISelectMany || child instanceof UISelectOne || child instanceof UISelectBoolean || child instanceof AbstractUICommand && child.getChildren().isEmpty() || child instanceof UIInput && "Hidden".equals(child.getRendererType()) || !(child instanceof UIOutput) && (!(child instanceof UICommand) && !(child instanceof UIPanel) || !((child = SortingUtils.getFirstSortableChild(child.getChildren())) instanceof UIOutput))) continue;
            break;
        }
        return result;
    }
}

