/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBox;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CollapsiblePanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer<T extends AbstractUIBox>
extends CollapsiblePanelRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        boolean collapsed = ((AbstractUICollapsiblePanel)component).isCollapsed();
        boolean autoSpacing = component.getAutoSpacing(facesContext);
        writer.startElement(HtmlElements.TOBAGO_BOX);
        writer.writeClassAttribute(BootstrapClass.CARD, collapsed ? TobagoClass.COLLAPSED : null, autoSpacing ? TobagoClass.AUTO__SPACING : null, component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (((AbstractUICollapsiblePanel)component).getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        String labelString = ((AbstractUIBox)component).getLabel();
        UIComponent bar = ComponentUtils.getFacet(component, Facets.bar);
        if (labelFacet != null || labelString != null || bar != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.CARD_HEADER, TobagoClass.BOX__HEADER);
            writer.startElement(HtmlElements.H3);
            if (labelFacet != null) {
                this.insideBegin(facesContext, Facets.label);
                for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                    child.encodeAll(facesContext);
                }
                this.insideEnd(facesContext, Facets.label);
            } else if (labelString != null) {
                writer.writeText(labelString);
            }
            writer.endElement(HtmlElements.H3);
            if (bar != null) {
                this.insideBegin(facesContext, Facets.bar);
                bar.encodeAll(facesContext);
                this.insideEnd(facesContext, Facets.bar);
            }
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_BODY);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_BOX);
    }
}

