/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeLabel;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeLabelRenderer<T extends AbstractUITreeLabel>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        boolean listbox = data instanceof AbstractUITreeListbox;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String text = StringUtils.defaultString((String)component.getValue());
        if (listbox) {
            writer.writeText(text);
        } else {
            writer.startElement(HtmlElements.LABEL);
            writer.writeClassAttribute(component.getCustomClass());
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
            writer.writeText(text);
            writer.endElement(HtmlElements.LABEL);
        }
    }
}

