/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;

public enum FacesVersion {
    VERSION_11,
    VERSION_12,
    VERSION_20,
    VERSION_21,
    VERSION_22,
    VERSION_23;

    private static FacesVersion currentVersion;
    private static boolean mojarra;
    private static boolean myfaces;

    private static boolean isAvailable(String className) {
        try {
            try {
                Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                return true;
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName(className, false, FacesVersion.class.getClassLoader());
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean supports12() {
        return currentVersion == VERSION_12 || currentVersion == VERSION_20 || currentVersion == VERSION_21 || currentVersion == VERSION_22 || currentVersion == VERSION_23;
    }

    public static boolean supports20() {
        return currentVersion == VERSION_20 || currentVersion == VERSION_21 || currentVersion == VERSION_22 || currentVersion == VERSION_23;
    }

    public static boolean supports21() {
        return currentVersion == VERSION_21 || currentVersion == VERSION_22 || currentVersion == VERSION_23;
    }

    public static boolean supports22() {
        return currentVersion == VERSION_22 || currentVersion == VERSION_23;
    }

    public static boolean supports23() {
        return currentVersion == VERSION_23;
    }

    public static boolean isMojarra() {
        return mojarra;
    }

    public static boolean isMyfaces() {
        return myfaces;
    }

    static {
        try {
            currentVersion = VERSION_11;
            Application.class.getMethod("getExpressionFactory", new Class[0]);
            currentVersion = VERSION_12;
            Application.class.getMethod("getDefaultValidatorInfo", new Class[0]);
            currentVersion = VERSION_20;
            FacesContext.class.getMethod("isReleased", new Class[0]);
            currentVersion = VERSION_21;
            Application.class.getMethod("getFlowHandler", new Class[0]);
            currentVersion = VERSION_22;
            Application.class.getMethod("getSearchExpressionHandler", new Class[0]);
            currentVersion = VERSION_23;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        mojarra = FacesVersion.isAvailable("com.sun.faces.application.ApplicationImpl");
        myfaces = FacesVersion.isAvailable("org.apache.myfaces.application.ApplicationImpl");
    }
}

