/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.util.Iterator;

public class VersionId {
    private String _versionString;
    private Entry _version;

    public VersionId(String version) {
        if (version == null) {
            return;
        }
        this._versionString = version;
        this._version = this._parseVersion(version);
    }

    public String toString() {
        return this._versionString;
    }

    public double getVersion() {
        double version = 0.0;
        if (this._versionString != null) {
            boolean hasDecimal = false;
            double divisor = 10.0;
            int sourceLength = this._versionString.length();
            for (int currIndex = 0; currIndex < sourceLength; ++currIndex) {
                char currChar = this._versionString.charAt(currIndex);
                if (currChar >= '0' && currChar <= '9') {
                    double addValue = currChar - 48;
                    if (hasDecimal) {
                        addValue /= divisor;
                        divisor *= 10.0;
                    } else {
                        version *= 10.0;
                    }
                    version += addValue;
                    continue;
                }
                if (currChar != '.') break;
                hasDecimal = true;
            }
        }
        return version;
    }

    public Iterator<String> iterator() {
        return new VIterator();
    }

    private Entry _parseVersion(String value) {
        Entry curr;
        int start = 0;
        int length = value.length();
        char[] data = new char[length + 1];
        int i = 0;
        value.getChars(0, length, data, 0);
        data[length] = '\u0000';
        char ch = data[i];
        Entry head = curr = new Entry();
        curr.next = curr;
        block4: while (i < length + 1) {
            while (Character.isWhitespace(ch)) {
                ch = data[++i];
            }
            switch (ch) {
                case '.': {
                    if (start != i) {
                        curr.next.text = new String(data, start, i - start);
                        curr = curr.next;
                        curr.next = new Entry();
                    }
                    ch = data[++i];
                    start = i;
                    continue block4;
                }
                case '\u0000': {
                    if (start != i) {
                        curr.next.text = new String(data, start, i - start);
                        curr = curr.next;
                        curr.next = new Entry();
                    }
                    ++i;
                    continue block4;
                }
            }
            ch = data[++i];
        }
        curr.next = null;
        return head;
    }

    private class VIterator
    implements Iterator<String> {
        private Entry _current;

        public VIterator() {
            this._current = VersionId.this._version;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return null != this._current;
        }

        @Override
        public String next() {
            String part = this._current.text;
            this._current = this._current.next;
            return part;
        }
    }

    private static class Entry {
        String text;
        Entry next;

        private Entry() {
        }
    }
}

