/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlHead;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.StyleSheetRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

@ResourceDependency(target="head", library="javax.faces", name="jsf.js")
public class HeadRenderer
extends XhtmlRenderer {
    private CoreRenderer _styleSheetRenderer = new StyleSheetRenderer(){

        protected void renderId(FacesContext context, UIComponent component) {
        }
    };
    private PropertyKey _titleKey;

    public HeadRenderer() {
        this(HtmlHead.TYPE);
    }

    protected HeadRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._titleKey = type.findKey("title");
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("head", comp);
        this.renderId(context, comp);
        String title = this.getTitle(comp, bean);
        if (title != null) {
            rw.startElement("title", null);
            rw.writeText((Object)title, null);
            rw.endElement("title");
        }
    }

    protected void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        HeadRenderer._writeGeneratorTag(context);
        this.delegateRenderer(context, rc, comp, bean, this._styleSheetRenderer);
        this.encodeComponentResources(context, "head");
        rw.endElement("head");
    }

    protected String getTitle(UIComponent component, FacesBean bean) {
        return HeadRenderer.toString((Object)bean.getProperty(this._titleKey));
    }

    private static void _writeGeneratorTag(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("meta", null);
        writer.writeAttribute("name", (Object)"generator", null);
        writer.writeAttribute("content", (Object)"Apache MyFaces Trinidad", null);
        writer.endElement("meta");
    }
}

