/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleSelectOneListboxRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _sizeKey;
    private PropertyKey _unselectedLabelKey;

    public SimpleSelectOneListboxRenderer() {
        this(CoreSelectOneListbox.TYPE);
    }

    public SimpleSelectOneListboxRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sizeKey = type.findKey("size");
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    public static int getListSize(int sizeAttr, int itemCount, boolean addOne) {
        if (sizeAttr < 2) {
            sizeAttr = Math.min(8, Math.max(2, itemCount));
            if (addOne) {
                ++sizeAttr;
            }
        }
        return sizeAttr;
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean, false);
        int count = selectItems == null ? 0 : selectItems.size();
        String unselectedLabel = this.getUnselectedLabel(component, bean);
        boolean hasUnselectedLabel = unselectedLabel != null;
        int size = SimpleSelectOneListboxRenderer.getListSize(this.getSize(component, bean), count, hasUnselectedLabel);
        writer.writeAttribute("size", (Object)IntegerUtils.getString((int)size), "size");
        if (hasUnselectedLabel) {
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            SimpleSelectOneListboxRenderer.encodeOption(context, rc, component, item, null, true, -1, selectedIndex < 0);
        }
        int counter = 0;
        for (int i = 0; i < count; ++i) {
            SelectItem item = selectItems.get(i);
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)item.getLabel(), null);
                SelectItem[] items = ((SelectItemGroup)item).getSelectItems();
                for (int j = 0; j < items.length; ++j) {
                    SimpleSelectOneListboxRenderer.encodeOption(context, rc, component, items[j], converter, valuePassThru, counter, selectedIndex == counter);
                    ++counter;
                }
                writer.endElement("optgroup");
                continue;
            }
            SimpleSelectOneListboxRenderer.encodeOption(context, rc, component, item, converter, valuePassThru, counter, selectedIndex == counter);
            ++counter;
        }
        writer.endElement("select");
    }

    @Override
    protected String getUnselectedLabel(UIComponent component, FacesBean bean) {
        return SimpleSelectOneListboxRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected String getOnchange(UIComponent component, FacesBean bean) {
        String onchange = super.getOnchange(component, bean);
        if (this.isAutoSubmit(component, bean)) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            String auto = this.getAutoSubmitScript(rc, component, bean);
            return XhtmlUtils.getChainedJS(onchange, auto, true);
        }
        return onchange;
    }

    protected int getSize(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._sizeKey);
        if (o == null) {
            o = this._sizeKey.getDefault();
        }
        if (o == null) {
            return -1;
        }
        return SimpleSelectOneListboxRenderer.toInt((Object)o);
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneListbox::content";
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneListbox";
    }
}

