/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public abstract class Scriptlet {
    public abstract Object getScriptletKey();

    public void outputScriptlet(FacesContext context, RenderingContext arc) throws IOException {
        if (!this._isAlreadyWritten(arc) && !this.__isOutsidePartialPage(arc)) {
            this._markAsWritten(arc);
            this.outputScriptletImpl(context, arc);
        }
    }

    boolean __isOutsidePartialPage(RenderingContext arc) {
        PartialPageContext pprContext = arc.getPartialPageContext();
        if (pprContext == null) {
            return false;
        }
        return !pprContext.isInsidePartialTarget();
    }

    public void registerSelf() {
        this.registerSelfWithKey(this.getScriptletKey());
    }

    public void embedInScriptTag(FacesContext context, RenderingContext arc) throws IOException {
        if (!this._isAlreadyWritten(arc)) {
            this._markAsWritten(arc);
            this.embedInScriptTagImpl(context, arc);
        }
    }

    protected void outputScriptletImpl(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        XhtmlRenderer.renderScriptDeferAttribute(context, arc);
        XhtmlRenderer.renderScriptTypeAttribute(context, arc);
        this.outputScriptletContent(context, arc);
        writer.endElement("script");
    }

    protected void embedInScriptTagImpl(FacesContext context, RenderingContext arc) throws IOException {
        this.outputScriptletContent(context, arc);
    }

    protected abstract void outputScriptletContent(FacesContext var1, RenderingContext var2) throws IOException;

    protected void outputDependency(FacesContext context, RenderingContext arc, Object dependency) throws IOException {
        XhtmlUtils.addLib(context, arc, dependency);
    }

    public void registerSelfWithKey(Object key) {
        XhtmlUtils.registerScriptlet(key, this);
    }

    private boolean _isAlreadyWritten(RenderingContext arc) {
        return arc.getProperties().get(this.getScriptletKey()) != null;
    }

    private void _markAsWritten(RenderingContext arc) {
        arc.getProperties().put(this.getScriptletKey(), Boolean.TRUE);
    }
}

