/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

public final class UploadedFiles {
    private long _totalMemory;
    private long _totalDiskSpace;
    private String _characterEncoding;
    private final Map<String, List<UploadedFile>> _map = new HashMap<String, List<UploadedFile>>();
    private static final String _UPLOADED_FILES_KEY = "org.apache.myfaces.trinidadinternal.webapp.UploadedFiles";

    public static UploadedFiles getUploadedFiles(FacesContext context) {
        return UploadedFiles.getUploadedFiles(context.getExternalContext());
    }

    public static UploadedFiles getUploadedFiles(ExternalContext context) {
        Map requestMap = context.getRequestMap();
        return (UploadedFiles)requestMap.get(_UPLOADED_FILES_KEY);
    }

    public static UploadedFiles getSessionUploadedFiles(FacesContext context) {
        return UploadedFiles.getSessionUploadedFiles(context.getExternalContext());
    }

    public static UploadedFiles getSessionUploadedFiles(ExternalContext context) {
        Map sessionMap = context.getSessionMap();
        UploadedFiles files = (UploadedFiles)sessionMap.get(_UPLOADED_FILES_KEY);
        if (files == null) {
            files = new UploadedFiles();
            sessionMap.put(_UPLOADED_FILES_KEY, files);
        }
        return files;
    }

    public static void setCharacterEncoding(ExternalContext externalContext, String encoding) {
        UploadedFiles files = UploadedFiles.getUploadedFiles(externalContext);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    public static void setCharacterEncoding(HttpServletRequest req, String encoding) {
        UploadedFiles files = (UploadedFiles)req.getAttribute(_UPLOADED_FILES_KEY);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    public static void setCharacterEncoding(PortletRequest req, String encoding) {
        UploadedFiles files = (UploadedFiles)req.getAttribute(_UPLOADED_FILES_KEY);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    private static void _setCharacterEncoding(UploadedFiles files, String encoding) {
        if (files != null) {
            files._characterEncoding = encoding;
        }
    }

    public UploadedFile getUploadedFile(String name) {
        List<UploadedFile> files = this.getUploadedFileList(name);
        if (files == null || files.isEmpty()) {
            return null;
        }
        for (UploadedFile file : files) {
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public List<UploadedFile> getUploadedFileList(String name) {
        List<UploadedFile> files = this._map.get(name);
        if (files == null || files.isEmpty()) {
            return null;
        }
        return files;
    }

    public static void retrieveSessionUploadedFiles(ExternalContext context, String name) {
        List<UploadedFile> sessionFileList;
        UploadedFiles sessionFiles = (UploadedFiles)context.getSessionMap().get(_UPLOADED_FILES_KEY);
        if (sessionFiles != null && (sessionFileList = sessionFiles.getUploadedFileList(name)) != null && !sessionFileList.isEmpty()) {
            UploadedFiles requestFiles = (UploadedFiles)context.getRequestMap().get(_UPLOADED_FILES_KEY);
            if (requestFiles == null) {
                requestFiles = new UploadedFiles(context);
            }
            for (UploadedFile sessionFile : sessionFileList) {
                requestFiles.__put(name, sessionFile);
            }
            sessionFiles.getUploadedFileMap().remove(name);
        }
    }

    public Iterator<String> getUploadedNames() {
        return this._map.keySet().iterator();
    }

    public Map<String, List<UploadedFile>> getUploadedFileMap() {
        return this._map;
    }

    public void dispose() {
        for (List<UploadedFile> files : this._map.values()) {
            if (files == null) continue;
            for (UploadedFile file : files) {
                if (file == null) continue;
                file.dispose();
            }
        }
        this._map.clear();
        this._totalMemory = 0L;
        this._totalDiskSpace = 0L;
    }

    UploadedFiles(ExternalContext externalContext) {
        externalContext.getRequestMap().put(_UPLOADED_FILES_KEY, this);
    }

    UploadedFiles() {
    }

    void __put(String name, UploadedFile file) {
        List<UploadedFile> files = this._map.get(name);
        if (files == null) {
            files = new ArrayList<UploadedFile>();
        }
        files.add(new FixFilename(file, this._characterEncoding));
        this._map.put(name, files);
    }

    public long getTotalMemory() {
        return this._totalMemory;
    }

    public long getTotalDiskSpace() {
        return this._totalDiskSpace;
    }

    public static class FixFilename
    implements UploadedFile,
    Serializable {
        private static final long serialVersionUID = -8586594511769079566L;
        private UploadedFile _file;
        private String _encoding;

        public FixFilename() {
        }

        public FixFilename(UploadedFile file, String encoding) {
            this._file = file;
            this._encoding = encoding;
        }

        public String getFilename() {
            String filename = this._file.getFilename();
            if (this._encoding == null) {
                return filename;
            }
            try {
                return CaboHttpUtils.decodeRequestParameter(filename, this._encoding, null);
            }
            catch (UnsupportedEncodingException uee) {
                assert (false);
                return filename;
            }
        }

        public String getContentType() {
            return this._file.getContentType();
        }

        public long getLength() {
            return this._file.getLength();
        }

        public Object getOpaqueData() {
            return this._file.getOpaqueData();
        }

        public InputStream getInputStream() throws IOException {
            return this._file.getInputStream();
        }

        public void dispose() {
            this._file.dispose();
        }
    }
}

