/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ContainerUtils;
import org.apache.myfaces.trinidadinternal.menu.GroupNode;
import org.apache.myfaces.trinidadinternal.menu.MenuNode;
import org.apache.myfaces.trinidadinternal.menu.MenuUtils;

@Deprecated
public class ImmutableGroupNode
extends GroupNode {
    private final String _icon;
    private List<MenuNode> _children = null;
    private final String _focusViewId;
    private final String _renderedStr;
    private final String _disabledStr;
    private final String _visibleStr;
    private final String _readOnlyStr;
    private final String _handlerId;
    private final String _bundleKey;
    private final String _bundleName;
    private final String _accessKey;
    private final String _id;
    private final String _modelId;
    private final String _labelAndAccessKey;
    private final String _defaultFocusPathStr;
    private final String _uniqueId;
    private final String _rootModelKey;
    private final int _rootId;
    private final String _label;
    private final String _idref;
    private final String[] _idrefList;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ImmutableGroupNode.class);

    public ImmutableGroupNode(GroupNode node) {
        this._icon = node.getIconProperty();
        this._focusViewId = node.getFocusViewIdProperty();
        this._renderedStr = node.getRenderedProperty();
        this._disabledStr = node.getDisabledProperty();
        this._visibleStr = node.getVisibleProperty();
        this._readOnlyStr = node.getReadOnlyProperty();
        this._handlerId = node.getHandlerIdProperty();
        this._bundleKey = node.getBundleKeyProperty();
        this._bundleName = node.getBundleNameProperty();
        this._accessKey = node.getAccessKeyProperty();
        this._id = node.getIdProperty();
        this._modelId = node.getModelIdProperty();
        this._uniqueId = node.getUniqueIdProperty();
        this._labelAndAccessKey = node.getLabelAndAccessKeyProperty();
        this._defaultFocusPathStr = node.getDefaultFocusPathProperty();
        this._rootModelKey = node.getRootModelKeyProperty();
        this._rootId = node.getRootIdProperty();
        this._label = node.getLabelProperty();
        this._idref = node.getIdRef();
        this._idrefList = node.getIdRefListProperty();
    }

    @Override
    public String getIdRef() {
        return this._idref;
    }

    @Override
    public MenuNode getRefNode() {
        MenuNode refNode = null;
        String[] idrefList = this._idrefList;
        List<MenuNode> children = this.getChildren();
        for (int i = 0; i < Array.getLength(idrefList); ++i) {
            for (MenuNode childNode : children) {
                String modelId = childNode.getModelId();
                String refNodeId = idrefList[i] + modelId;
                refNode = (MenuNode)this.getRootModel().getNode(refNodeId);
                if (refNode == null) continue;
                break;
            }
            if (refNode == null) continue;
            if (refNode.getRendered() && !refNode.getDisabled() && !refNode.getReadOnly() && refNode.getVisible()) break;
            refNode = null;
        }
        if (refNode == null) {
            _LOG.severe("GroupNode " + this.getLabel() + " refers to no valid node.\n");
            return null;
        }
        return refNode;
    }

    @Override
    public final String getLabel() {
        if (this._bundleKey != null && this._bundleName != null) {
            MenuUtils.loadBundle(this._bundleName, this._bundleKey + this.getHandlerId());
        }
        if (this._label != null && ContainerUtils.isValueReference((String)this._label)) {
            return this._evalElStr(this._label);
        }
        if (this._label == null && this._labelAndAccessKey != null) {
            String label;
            int ampIdx = 0;
            String labelAndAccessKeyEval = null;
            String labelAndAccessKey = this._labelAndAccessKey;
            labelAndAccessKeyEval = ContainerUtils.isValueReference((String)labelAndAccessKey) ? this._evalElStr(labelAndAccessKey) : labelAndAccessKey;
            if (labelAndAccessKeyEval == null || (ampIdx = labelAndAccessKeyEval.indexOf(38)) == -1) {
                label = labelAndAccessKeyEval;
            } else if (ampIdx == labelAndAccessKeyEval.length() - 1) {
                label = labelAndAccessKeyEval.substring(0, ampIdx);
            } else {
                String label1;
                char[] keyArray = labelAndAccessKeyEval.toCharArray();
                int len = labelAndAccessKeyEval.length();
                char[] keyArray2 = new char[len];
                int j = 0;
                boolean accessKeyFound = false;
                int i = 0;
                j = 0;
                while (i < len) {
                    if (keyArray[i] == '&' && !accessKeyFound && keyArray[++i] != '&') {
                        String accessKey = labelAndAccessKeyEval.substring(i, i + 1);
                        accessKeyFound = true;
                    }
                    keyArray2[j] = keyArray[i];
                    ++i;
                    ++j;
                }
                label = label1 = new String(keyArray2, 0, j);
            }
            return label;
        }
        return this._label;
    }

    @Override
    public final String getIcon() {
        return MenuUtils.evalString(this._icon);
    }

    @Override
    public final List<MenuNode> getChildren() {
        return this._children;
    }

    @Override
    public void setChildren(List<MenuNode> children) {
        this._children = children;
    }

    @Override
    public final String getFocusViewId() {
        return this._focusViewId;
    }

    @Override
    public final boolean getRendered() {
        boolean rendered = MenuUtils.evalBoolean(this._renderedStr, true);
        return rendered;
    }

    @Override
    public final boolean getDisabled() {
        boolean disabled = MenuUtils.evalBoolean(this._disabledStr, false);
        return disabled;
    }

    @Override
    public final boolean getVisible() {
        boolean visible = MenuUtils.evalBoolean(this._visibleStr, true);
        return visible;
    }

    @Override
    public final boolean getReadOnly() {
        boolean readOnly = MenuUtils.evalBoolean(this._readOnlyStr, false);
        return readOnly;
    }

    @Override
    protected final String getHandlerId() {
        return this._handlerId;
    }

    public final String getBundleKey() {
        return this._bundleKey;
    }

    public final String getBundleName() {
        return this._bundleName;
    }

    @Override
    public final char getAccessKey() {
        if (this._accessKey == null && this._labelAndAccessKey != null) {
            int ampIdx = 0;
            String labelAndAccessKeyEval = null;
            String labelAndAccessKey = this._labelAndAccessKey;
            labelAndAccessKeyEval = ContainerUtils.isValueReference((String)labelAndAccessKey) ? this._evalElStr(labelAndAccessKey) : labelAndAccessKey;
            String accessKey = null;
            if (labelAndAccessKeyEval == null || (ampIdx = labelAndAccessKeyEval.indexOf(38)) == -1) {
                String label = labelAndAccessKeyEval;
            } else if (ampIdx == labelAndAccessKeyEval.length() - 1) {
                String label = labelAndAccessKeyEval.substring(0, ampIdx);
            } else {
                String label1;
                char[] keyArray = labelAndAccessKeyEval.toCharArray();
                int len = labelAndAccessKeyEval.length();
                char[] keyArray2 = new char[len];
                int j = 0;
                boolean accessKeyFound = false;
                int i = 0;
                j = 0;
                while (i < len) {
                    if (keyArray[i] == '&' && !accessKeyFound && keyArray[++i] != '&') {
                        accessKey = labelAndAccessKeyEval.substring(i, i + 1);
                        accessKeyFound = true;
                    }
                    keyArray2[j] = keyArray[i];
                    ++i;
                    ++j;
                }
                String label = label1 = new String(keyArray2, 0, j);
            }
            return accessKey != null ? accessKey.charAt(0) : (char)'\u0000';
        }
        String accessKeyStr = MenuUtils.evalString(this._accessKey);
        if (accessKeyStr == null || accessKeyStr.length() > 1) {
            return '\u0000';
        }
        return accessKeyStr.charAt(0);
    }

    @Override
    public final String getLabelAndAccessKey() {
        if (this._labelAndAccessKey != null) {
            String label;
            int ampIdx = 0;
            String labelAndAccessKeyEval = null;
            String labelAndAccessKey = this._labelAndAccessKey;
            if (this._bundleKey != null && this._bundleName != null) {
                MenuUtils.loadBundle(this._bundleName, this._bundleKey + this.getHandlerId());
            }
            labelAndAccessKeyEval = ContainerUtils.isValueReference((String)labelAndAccessKey) ? this._evalElStr(labelAndAccessKey) : labelAndAccessKey;
            String accessKey = null;
            if (labelAndAccessKeyEval == null || (ampIdx = labelAndAccessKeyEval.indexOf(38)) == -1) {
                label = labelAndAccessKeyEval;
            } else if (ampIdx == labelAndAccessKeyEval.length() - 1) {
                label = labelAndAccessKeyEval.substring(0, ampIdx);
            } else {
                String label1;
                char[] keyArray = labelAndAccessKeyEval.toCharArray();
                int len = labelAndAccessKeyEval.length();
                char[] keyArray2 = new char[len];
                int j = 0;
                boolean accessKeyFound = false;
                int i = 0;
                j = 0;
                while (i < len) {
                    if (keyArray[i] == '&' && !accessKeyFound && keyArray[++i] != '&') {
                        accessKey = labelAndAccessKeyEval.substring(i, i + 1);
                        accessKeyFound = true;
                    }
                    keyArray2[j] = keyArray[i];
                    ++i;
                    ++j;
                }
                label = label1 = new String(keyArray2, 0, j);
            }
            if (accessKey == null) {
                return label;
            }
            return this._joinLabelAndAccessKey(label, accessKey);
        }
        return null;
    }

    @Override
    public final String getId() {
        return this._id;
    }

    @Override
    public final String getModelId() {
        return this._modelId;
    }

    @Override
    public final String getUniqueId() {
        return this._uniqueId;
    }

    @Override
    public final boolean getDefaultFocusPath() {
        boolean defaultFocusPath = MenuUtils.evalBoolean(this._defaultFocusPathStr, false);
        return defaultFocusPath;
    }

    @Override
    public final String getRootModelKey() {
        return this._rootModelKey;
    }

    @Override
    public final int getRootId() {
        return this._rootId;
    }

    private String _evalElStr(String str) {
        if (str == null) {
            return null;
        }
        String keystr = MenuUtils.stringReplaceFirst(str.trim(), this._bundleKey, this._bundleKey + this.getHandlerId());
        String elVal = MenuUtils.getBoundValue(keystr, String.class);
        return elVal;
    }

    private String _joinLabelAndAccessKey(String label, String accessKey) {
        char[] keyArray = label.toCharArray();
        int len = label.length();
        int lentimes2 = len * 2;
        char[] keyArray2 = new char[lentimes2];
        int j = 0;
        boolean accessKeyFound = false;
        int i = 0;
        j = 0;
        while (i < len) {
            if (keyArray[i] == accessKey.charAt(0) && !accessKeyFound) {
                keyArray2[j] = 38;
                ++j;
                accessKeyFound = true;
            }
            keyArray2[j] = keyArray[i];
            if (keyArray[i] == '&') {
                keyArray2[++j] = keyArray[i];
            }
            ++i;
            ++j;
        }
        String combinedLabel = new String(keyArray2, 0, j);
        return combinedLabel;
    }
}

