/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXPoll;
import org.apache.myfaces.trinidad.component.core.CorePoll;
import org.apache.myfaces.trinidad.component.core.nav.CoreGoButton;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.PollEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PollRenderer
extends XhtmlRenderer {
    private PropertyKey _intervalKey;
    private static final String _PRE_START_SCRIPT_AUTO_REFRESH = " if (!self._trPollManager) _trPollManager = new _TrPollManager(); _trPollManager.addAndActivate(\"";
    private static final String _START_SCRIPT_PARTIAL_FORM = "_submitPartialChange(";
    private static final String _START_SCRIPT_FULL_FORM = "submitForm(";
    private static final String _END_SCRIPT = ");";
    private static final String _MIDDLE_SCRIPT_AUTO_REFRESH = ")\", ";
    private static final int _POLL_INTERVAL_DEFAULT = 5000;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PollRenderer.class);

    public PollRenderer() {
        super(CorePoll.TYPE);
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object event = parameters.get("event");
        if ("poll".equals(event)) {
            String id;
            Object source = parameters.get("source");
            String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
            if (id.equals(source)) {
                PartialPageUtils.forcePartialRendering(facesContext);
                RequestContext.getCurrentInstance().addPartialTarget(component);
                UIXPoll poll = (UIXPoll)component;
                new PollEvent(component).queue();
                if (poll.isImmediate()) {
                    facesContext.renderResponse();
                }
            }
        }
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._intervalKey = type.findKey("interval");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        XhtmlUtils.addLib(context, rc, "PollManager()");
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", component);
        this.renderId(context, component);
        if (this._isAutoRefreshMode(rc)) {
            this._renderPollingScript(context, rc, component, bean);
        } else {
            this._renderManualRefresh(context, rc, component, bean);
        }
        rw.endElement("span");
    }

    private void _renderManualRefresh(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        String elementID = this.getClientId(context, component);
        boolean isPartial = PartialPageUtils.supportsPartialRendering(rc);
        String onclick = this._getScriptContents(rc, component, bean, elementID, isPartial, false);
        CoreGoButton goButton = new CoreGoButton();
        goButton.setOnclick(onclick);
        goButton.setText(rc.getTranslatedString("af_poll.MANUAL"));
        goButton.encodeBegin(context);
        goButton.encodeEnd(context);
    }

    private void _renderPollingScript(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        String elementID = this.getClientId(context, component);
        boolean isPartial = PartialPageUtils.supportsPartialRendering(rc);
        String buffer = this._getScriptContents(rc, component, bean, elementID, isPartial, true);
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("script", component);
        PollRenderer.renderScriptTypeAttribute(context, rc);
        PollRenderer.renderScriptDeferAttribute(context, rc);
        rw.writeText((Object)buffer, null);
        rw.endElement("script");
    }

    protected int getInterval(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._intervalKey);
        if (o == null) {
            o = this._intervalKey.getDefault();
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return 5000;
    }

    private String _getScriptContents(RenderingContext rc, UIComponent component, FacesBean bean, String elementID, boolean isPartial, boolean isAutoRefreshMode) {
        int pollInterval = 0;
        if (isAutoRefreshMode) {
            pollInterval = this.getInterval(component, bean);
        }
        if (rc.getFormData() == null) {
            _LOG.warning("POLL_COMPONENT_MUST_INSIDE_FORM", (Object)elementID);
            return null;
        }
        String startScript = PollRenderer._getStartScript(isPartial, isAutoRefreshMode, elementID);
        String argumentString = PollRenderer._getArgumentString(elementID, rc.getFormData().getName(), isPartial);
        int length = PollRenderer._getScriptBufferLength(startScript, argumentString, pollInterval, isAutoRefreshMode);
        StringBuilder builder = new StringBuilder(length);
        builder.append(startScript);
        if (this._isAutoRefreshMode(rc)) {
            builder.append(XhtmlUtils.escapeJS(argumentString));
        } else {
            builder.append(argumentString);
        }
        if (isAutoRefreshMode) {
            builder.append(_MIDDLE_SCRIPT_AUTO_REFRESH);
            builder.append(pollInterval);
        }
        builder.append(_END_SCRIPT);
        return builder.toString();
    }

    private static int _getScriptBufferLength(String startScript, String argumentString, Integer pollInterval, boolean isAutoRefreshMode) {
        if (startScript == null || argumentString == null) {
            return 0;
        }
        int length = startScript.length() + argumentString.length() + _MIDDLE_SCRIPT_AUTO_REFRESH.length() + _END_SCRIPT.length();
        if (isAutoRefreshMode && pollInterval != null) {
            length += pollInterval.toString().length() + 3;
        }
        return length;
    }

    private static String _getStartScript(boolean isPartial, boolean isAutoRefreshMode, String elementID) {
        String startScript = "";
        if (isAutoRefreshMode) {
            startScript = _PRE_START_SCRIPT_AUTO_REFRESH;
            startScript = startScript + elementID;
            startScript = startScript + "\", \"";
        }
        startScript = isPartial ? startScript + _START_SCRIPT_PARTIAL_FORM : startScript + _START_SCRIPT_FULL_FORM;
        return startScript;
    }

    private static String _getArgumentString(String elementID, String formName, boolean isPartial) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("'");
        buffer.append(formName);
        buffer.append("',0,");
        buffer.append("{event:'poll',source:'");
        buffer.append(elementID);
        buffer.append("'}");
        return buffer.toString();
    }

    private boolean _isAutoRefreshMode(RenderingContext rc) {
        return !PollRenderer.isScreenReaderMode((RenderingContext)rc);
    }
}

