/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib.util;

import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.util.DateUtils;

public final class TagUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TagUtils.class);

    private TagUtils() {
    }

    public static void assertNotNull(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
    }

    public static String getString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean getBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static int getInteger(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static long getLong(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.valueOf(value.toString());
    }

    public static double getDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        return Double.valueOf(value.toString());
    }

    public static float getFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        return Float.valueOf(value.toString()).floatValue();
    }

    public static String[] getStringArray(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        return TagUtils._getTokensArray(value.toString());
    }

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return TagUtils._parseISODate(value.toString());
    }

    public static Date getDateWithMaxTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        Date d = TagUtils._parseISODate(value.toString());
        Calendar c = Calendar.getInstance();
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            c.setTimeZone(tz);
        }
        c.setTime(d);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Locale getLocale(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        return TagUtils._getLocale(value.toString());
    }

    public static TimeZone getTimeZone(Object value) {
        if (value == null) {
            return null;
        }
        return DateUtils.getSupportedTimeZone(value.toString());
    }

    public static List<Color> getColorList(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        String valueStr = value.toString();
        String[] tokenArray = TagUtils._getTokensArray(valueStr);
        if (tokenArray == null) {
            return null;
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (int index = 0; index < tokenArray.length; ++index) {
            String colorCode = tokenArray[index];
            if (!colorCode.startsWith("#")) {
                throw new ParseException(_LOG.getMessage("COLOR_CODE_DOES_NOT_START_WITH_POUNDSIGN", new Object[]{colorCode, value}), valueStr.indexOf(colorCode));
            }
            int rgb = Integer.parseInt(colorCode.substring(1), 16);
            colorList.add(new Color(rgb));
        }
        return colorList;
    }

    public static Color getColor(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        String colorCode = value.toString();
        if (!colorCode.startsWith("#")) {
            throw new ParseException(_LOG.getMessage("COLOR_CODE_DOES_NOT_START_WITH_POUNDSIGN", new Object[]{colorCode, value}), 0);
        }
        int rgb = Integer.parseInt(colorCode.substring(1), 16);
        return new Color(rgb);
    }

    private static String[] _getTokensArray(String tokenComposite) throws ParseException {
        if (tokenComposite == null || "".equals(tokenComposite)) {
            return null;
        }
        return XMLUtils.parseNameTokens(tokenComposite);
    }

    private static final Date _parseISODate(String stringValue) {
        try {
            return TagUtils._getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            _LOG.info("CANNOT_PARSE_VALUE_INTO_DATE_WITH_YYYY_MM_DD_PATTERN", (Object)stringValue);
            return null;
        }
    }

    private static Locale _getLocale(String locale) {
        String localeStr = locale.replace('-', '_');
        String[] tokens = localeStr.split("[_]", 3);
        Locale locl = null;
        if (tokens.length == 1) {
            locl = new Locale(tokens[0]);
        } else if (tokens.length == 2) {
            locl = new Locale(tokens[0], tokens[1]);
        } else if (tokens.length == 3) {
            locl = new Locale(tokens[0], tokens[1], tokens[2]);
        } else assert (tokens.length < 4);
        return locl;
    }

    private static DateFormat _getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }
}

