/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;

public final class RowKeySetAttributeChange
extends AttributeComponentChange {
    private static final long serialVersionUID = 1L;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RowKeySetAttributeChange.class);
    private final String _clientId;

    public RowKeySetAttributeChange(String clientId, String propertyName, Object value) {
        super(propertyName, value);
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("No clientId specified");
        }
        this._clientId = clientId;
    }

    @Override
    public void changeComponent(UIComponent component) {
        Map attributeMap = component.getAttributes();
        Object newAttributeValue = this.getAttributeValue();
        String attrName = this.getAttributeName();
        if (newAttributeValue instanceof RowKeySet || newAttributeValue == null) {
            this._updateRowKeySetInPlace(component, attrName, (RowKeySet)newAttributeValue);
        } else if (newAttributeValue instanceof ValueExpression) {
            component.setValueExpression(attrName, (ValueExpression)newAttributeValue);
            attributeMap.remove(attrName);
        } else if (newAttributeValue instanceof ValueBinding) {
            component.setValueBinding(attrName, (ValueBinding)newAttributeValue);
            attributeMap.remove(attrName);
        } else {
            attributeMap.put(attrName, newAttributeValue);
        }
    }

    private void _updateRowKeySetInPlace(UIComponent component, String attrName, RowKeySet newValue) {
        ValueExpression oldExpression = component.getValueExpression(attrName);
        FacesContext context = FacesContext.getCurrentInstance();
        context.getViewRoot().invokeOnComponent(context, this._clientId, (ContextCallback)new GetOldValueAndUpdate(oldExpression, attrName, newValue));
    }

    private static final class GetOldValueAndUpdate
    implements ContextCallback {
        private final ValueExpression _expression;
        private final String _attributeName;
        private final RowKeySet _newKeySet;

        public GetOldValueAndUpdate(ValueExpression expression, String attributeName, RowKeySet newKeySet) {
            this._expression = expression;
            this._attributeName = attributeName;
            this._newKeySet = newKeySet;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            Object oldValue = this._expression != null ? this._expression.getValue(context.getELContext()) : target.getAttributes().get(this._attributeName);
            this._updateKeySet(target, oldValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void _updateKeySet(UIComponent component, Object oldValue) {
            if (oldValue == this._newKeySet) return;
            if (oldValue instanceof RowKeySet) {
                RowKeySet oldKeySet = (RowKeySet)oldValue;
                try {
                    oldKeySet.clear();
                    if (this._newKeySet == null) return;
                    oldKeySet.addAll(this._newKeySet);
                    return;
                }
                catch (Exception e) {
                    _LOG.warning("FAILED_ROWKEYSETATTRIBUTECHANGE", e);
                    return;
                }
            } else {
                component.getAttributes().put(this._attributeName, this._newKeySet);
            }
        }
    }
}

