/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXSwitcher
extends UIXComponentBase
implements FlattenedComponent {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey FACET_NAME_KEY = TYPE.registerKey("facetName", String.class);
    public static final PropertyKey DEFAULT_FACET_KEY = TYPE.registerKey("defaultFacet", String.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Switcher";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Switcher";

    public UIXSwitcher() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, S callbackContext) throws IOException {
        boolean abort;
        block7: {
            this.setupFlattenedContext(context, cpContext);
            try {
                UIComponent facet = this._getFacet();
                if (facet != null) {
                    this.setupFlattenedChildrenContext(context, cpContext);
                    try {
                        abort = UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, facet, callbackContext);
                        break block7;
                    }
                    finally {
                        this.tearDownFlattenedChildrenContext(context, cpContext);
                    }
                }
                abort = false;
            }
            finally {
                this.tearDownFlattenedContext(context, cpContext);
            }
        }
        return abort;
    }

    @Override
    public boolean isFlatteningChildren(FacesContext context) {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        UIComponent facet = this._getFacet();
        if (facet != null) {
            facet.encodeAll(context);
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected Iterator<UIComponent> getRenderedFacetsAndChildren(FacesContext facesContext) {
        UIComponent facet = this._getFacet();
        if (facet == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singleton(facet).iterator();
    }

    private UIComponent _getFacet() {
        UIComponent facet;
        if (!this.isRendered()) {
            return null;
        }
        String facetName = this.getFacetName();
        if (facetName != null && (facet = this.getFacet(facetName)) != null) {
            return facet;
        }
        String defaultFacet = this.getDefaultFacet();
        if (defaultFacet != null) {
            return this.getFacet(defaultFacet);
        }
        return null;
    }

    public final String getFacetName() {
        return ComponentUtils.resolveString(this.getProperty(FACET_NAME_KEY));
    }

    public final void setFacetName(String facetName) {
        this.setProperty(FACET_NAME_KEY, facetName);
    }

    public final String getDefaultFacet() {
        return ComponentUtils.resolveString(this.getProperty(DEFAULT_FACET_KEY));
    }

    public final void setDefaultFacet(String defaultFacet) {
        this.setProperty(DEFAULT_FACET_KEY, defaultFacet);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Switcher";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSwitcher(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lock();
    }
}

