"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const sinon = __importStar(require("sinon"));
const AsynchronousProbe_1 = require("./AsynchronousProbe");
const AsyncQueue_1 = require("../../impl/util/AsyncQueue");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const AjaxImpl_1 = require("../../impl/AjaxImpl");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
(0, mocha_1.describe)('Asynchronous Queue tests', () => {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.stub(global.faces.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('one entry', (done) => {
        const probe1 = new AsynchronousProbe_1.ProbeClass(setTimeout);
        const queue = new AsyncQueue_1.AsynchronousQueue();
        probe1.then(() => {
            (0, chai_1.expect)(probe1.thenPerformed, "called").to.be.true;
            done();
        });
        queue.enqueue(probe1);
    });
    (0, mocha_1.it)('multiple  entries', (done) => {
        const queue = new AsyncQueue_1.AsynchronousQueue();
        const probe1 = new AsynchronousProbe_1.ProbeClass(setTimeout);
        const probe2 = new AsynchronousProbe_1.ProbeClass(setTimeout);
        const probe3 = new AsynchronousProbe_1.ProbeClass(setTimeout);
        let finallyCnt = 0;
        probe1.then(() => {
            (0, chai_1.expect)(probe1.thenPerformed, "called").to.be.true;
            (0, chai_1.expect)(queue.isEmpty).to.be.false;
            finallyCnt++;
        });
        probe2.then(() => {
            (0, chai_1.expect)(probe2.thenPerformed, "called").to.be.true;
            (0, chai_1.expect)(queue.isEmpty).to.be.false;
            finallyCnt++;
        });
        probe3.then(() => {
            (0, chai_1.expect)(probe3.thenPerformed, "called").to.be.true;
            finallyCnt++;
        });
        queue.enqueue(probe1);
        queue.enqueue(probe2);
        queue.enqueue(probe3);
        Promise.all([probe1.value, probe2.value, probe3.value]).then(() => {
            (0, chai_1.expect)(queue.isEmpty).to.be.true;
            (finallyCnt == 3) ? done() : null;
        });
    });
    //TODO error test?
});
//# sourceMappingURL=AsynchronousQueueTest.spec.js.map