/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.modules.autoupdate.ui.ModuleInstallerSupport;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.Parameters;

public final class PluginManager {
    private PluginManager() {
    }

    public static boolean openInstallWizard(OperationContainer<InstallSupport> container) {
        if (container == null) {
            throw new IllegalArgumentException("OperationContainer cannot be null.");
        }
        List<OperationContainer.OperationInfo<InstallSupport>> all = container.listAll();
        if (all.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot be empty.");
        }
        List<OperationContainer.OperationInfo<InstallSupport>> invalid = container.listInvalid();
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot contain invalid elements but " + invalid);
        }
        OperationContainer.OperationInfo<InstallSupport> info = all.get(0);
        OperationWizardModel.OperationType doOperation = info.getUpdateUnit().getInstalled() == null ? OperationWizardModel.OperationType.INSTALL : OperationWizardModel.OperationType.UPDATE;
        return new InstallUnitWizard().invokeWizard(new InstallUnitWizardModel(doOperation, container), false);
    }

    public static void openInstallWizard(OperationContainer<InstallSupport> container, boolean runInBackground) {
        if (container == null) {
            throw new IllegalArgumentException("OperationContainer cannot be null.");
        }
        List<OperationContainer.OperationInfo<InstallSupport>> all = container.listAll();
        if (all.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot be empty.");
        }
        List<OperationContainer.OperationInfo<InstallSupport>> invalid = container.listInvalid();
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot contain invalid elements but " + invalid);
        }
        OperationContainer.OperationInfo<InstallSupport> info = all.get(0);
        OperationWizardModel.OperationType doOperation = info.getUpdateUnit().getInstalled() == null ? OperationWizardModel.OperationType.INSTALL : OperationWizardModel.OperationType.UPDATE;
        new InstallUnitWizard().invokeWizard(new InstallUnitWizardModel(doOperation, container), true, runInBackground);
    }

    @CheckForNull
    public static Object installSingle(@NonNull String codenamebase, @NonNull String displayName, Object ... alternativeOptions) {
        Parameters.notNull("cnb", codenamebase);
        Parameters.notNull("displayName", displayName);
        Parameters.notNull("alternativeOptions", alternativeOptions);
        try {
            return new ModuleInstallerSupport(alternativeOptions).installPlugins(displayName, Collections.singleton(codenamebase));
        }
        catch (OperationException ex) {
            Logger.getLogger(PluginManager.class.getName()).log(Level.WARNING, null, ex);
            return -1;
        }
    }

    @CheckForNull
    public static Object install(@NonNull Set<String> codenamebases, Object ... alternativeOptions) {
        Parameters.notNull("cnb", codenamebases);
        Parameters.notNull("alternativeOptions", alternativeOptions);
        if (codenamebases.isEmpty()) {
            throw new IllegalArgumentException("No plugins to install");
        }
        try {
            return new ModuleInstallerSupport(alternativeOptions).installPlugins(null, codenamebases);
        }
        catch (OperationException ex) {
            Logger.getLogger(PluginManager.class.getName()).log(Level.WARNING, null, ex);
            return -1;
        }
    }
}

