/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.wizards.LazyOperationDescriptionStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class LazyInstallUnitWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor> {
    private int index;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    private Collection<LazyUnit> installModel;
    private OperationWizardModel.OperationType doOperation;
    private boolean forceReload;

    public LazyInstallUnitWizardIterator(Collection<LazyUnit> model, OperationWizardModel.OperationType doOperation, boolean forceReload) {
        this.installModel = model;
        this.doOperation = doOperation;
        this.forceReload = forceReload;
        this.createPanels();
        this.index = 0;
    }

    private void createPanels() {
        assert (this.panels != null && this.panels.isEmpty()) : "Panels are still empty";
        this.panels.add(new LazyOperationDescriptionStep(this.installModel, this.doOperation, this.forceReload));
    }

    @Override
    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    @Override
    public String name() {
        return NbBundle.getMessage(LazyInstallUnitWizardIterator.class, "InstallUnitWizard_Title");
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public void nextPanel() {
    }

    @Override
    public void previousPanel() {
    }

    @Override
    public synchronized void addChangeListener(ChangeListener l) {
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener l) {
    }

    public static class LazyUnit {
        private String codeName;
        private String displayName;
        private String oldVersion;
        private String newVersion;
        private String notification;
        private static final String DELIMETER = "|";

        private LazyUnit(String codeName, String displayName, String oldVersion, String newVersion, String notification) {
            this.codeName = codeName;
            this.displayName = displayName;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.notification = notification;
        }

        public static void storeUpdateElements(OperationWizardModel.OperationType operationType, Collection<UpdateElement> elements) {
            Preferences p = LazyUnit.getPreferences(operationType);
            try {
                if (p.keys().length > 0) {
                    p.clear();
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            if (elements == null) {
                return;
            }
            for (UpdateElement el : elements) {
                p.put(el.getCodeName(), LazyUnit.toString(el));
            }
        }

        public static void storeLazyUnits(OperationWizardModel.OperationType operationType, Collection<LazyUnit> units) {
            Preferences p = LazyUnit.getPreferences(operationType);
            try {
                if (p.keys().length > 0) {
                    p.clear();
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            if (units == null) {
                return;
            }
            for (LazyUnit u : units) {
                p.put(u.getCodeName(), u.toString());
            }
        }

        public static Collection<LazyUnit> loadLazyUnits(OperationWizardModel.OperationType operationType) {
            Preferences p = LazyUnit.getPreferences(operationType);
            HashSet<LazyUnit> units = new HashSet<LazyUnit>();
            try {
                for (String cn : p.keys()) {
                    units.add(LazyUnit.parseLazyUnit(p.get(cn, null)));
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(LazyInstallUnitWizardIterator.class.getName()).log(Level.WARNING, ex.getLocalizedMessage(), ex);
                return null;
            }
            return units;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getDisplayName() {
            return this.displayName == null ? this.codeName : this.displayName;
        }

        public String getOldVersion() {
            return this.oldVersion == null ? "" : this.oldVersion.trim();
        }

        public String getNewVersion() {
            return this.newVersion == null ? "" : this.newVersion.trim();
        }

        public String getNotification() {
            return this.notification == null ? "" : this.notification.trim();
        }

        public String toString() {
            return this.codeName + DELIMETER + (this.displayName == null ? this.codeName : this.displayName) + DELIMETER + (this.oldVersion == null ? " " : this.oldVersion) + DELIMETER + (this.newVersion == null ? " " : this.newVersion) + DELIMETER + (this.notification == null ? " " : this.notification);
        }

        public static String toString(UpdateElement el) {
            return el.getCodeName() + DELIMETER + (el.getDisplayName() == null ? el.getCodeName() : el.getDisplayName()) + DELIMETER + (el.getUpdateUnit().getInstalled() == null ? " " : el.getUpdateUnit().getInstalled().getSpecificationVersion()) + DELIMETER + (el.getSpecificationVersion() == null ? " " : el.getSpecificationVersion()) + DELIMETER + (el.getNotification() == null ? " " : el.getNotification());
        }

        private static LazyUnit parseLazyUnit(String s) {
            StringTokenizer tokenizer = new StringTokenizer(s, DELIMETER);
            assert (5 == tokenizer.countTokens()) : "5 tokens for " + s;
            String codeName = tokenizer.nextToken();
            String displayName = tokenizer.nextToken();
            String oldVersion = tokenizer.nextToken();
            String newVersion = tokenizer.nextToken();
            String notification = tokenizer.nextToken();
            return new LazyUnit(codeName, displayName, oldVersion, newVersion, notification);
        }

        private static Preferences getPreferences(OperationWizardModel.OperationType type) {
            return NbPreferences.forModule(AutoupdateCheckScheduler.class).node(type.toString());
        }
    }
}

