/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation;

import java.util.List;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.EntityMappingsUtilities;

public final class AttributesHelper {
    private final TypeElement typeElement;
    private final AnnotationModelHelper helper;
    private final PropertyHandler propertyHandler;
    private final boolean fieldAccess;

    public AttributesHelper(AnnotationModelHelper helper, TypeElement typeElement, PropertyHandler propertyHandler) {
        this.helper = helper;
        this.typeElement = typeElement;
        this.propertyHandler = propertyHandler;
        if (typeElement == null) {
            this.fieldAccess = true;
            return;
        }
        List<? extends Element> elements = typeElement.getEnclosedElements();
        this.fieldAccess = EntityMappingsUtilities.hasFieldAccess(helper, elements);
    }

    public void parse() {
        if (this.typeElement == null) {
            return;
        }
        for (Element element : this.typeElement.getEnclosedElements()) {
            ElementKind elementKind = element.getKind();
            if (this.fieldAccess) {
                if (!ElementKind.FIELD.equals((Object)elementKind)) continue;
                this.handleProperty(element);
                continue;
            }
            if (!ElementKind.METHOD.equals((Object)elementKind)) continue;
            this.handleProperty(element);
        }
    }

    private void handleProperty(Element element) {
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        String propertyName = element.getSimpleName().toString();
        if (ElementKind.METHOD.equals((Object)element.getKind())) {
            if ((propertyName = EntityMappingsUtilities.getterNameToPropertyName(propertyName)) == null) {
                return;
            }
            ExecutableElement el = (ExecutableElement)element;
            if (el.getParameters() != null && el.getParameters().size() > 0) {
                return;
            }
        }
        this.propertyHandler.handleProperty(element, propertyName);
    }

    public boolean hasFieldAccess() {
        return this.fieldAccess;
    }

    public static interface PropertyHandler {
        public void handleProperty(Element var1, String var2);
    }
}

