/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.NestingKind;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.Bundle;
import org.netbeans.modules.java.hints.introduce.InstanceRefFinder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class InitializerCanBeStatic {
    public static ErrorDescription run(HintContext ctx) {
        TreePath path = ctx.getPath();
        if (((BlockTree)path.getLeaf()).isStatic()) {
            return null;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        Tree l = parentPath.getLeaf();
        if (!(l instanceof ClassTree)) {
            return null;
        }
        Element el = ctx.getInfo().getTrees().getElement(parentPath);
        if (el == null || !el.getKind().isClass()) {
            return null;
        }
        TypeElement tel = (TypeElement)el;
        if (!(tel.getNestingKind() == NestingKind.TOP_LEVEL || tel.getNestingKind() == NestingKind.MEMBER && tel.getModifiers().contains((Object)Modifier.STATIC))) {
            return null;
        }
        InstanceRefFinder finder = new InstanceRefFinder(ctx.getInfo(), path);
        finder.process();
        if (finder.containsInstanceReferences() || finder.containsReferencesToSuper()) {
            return null;
        }
        return ErrorDescriptionFactory.forTree(ctx, path, Bundle.TEXT_InitializerCanBeStatic(), new MakeInitStatic(TreePathHandle.create(path, ctx.getInfo())).toEditorFix());
    }

    private static class MakeInitStatic
    extends JavaFix {
        public MakeInitStatic(TreePathHandle handle) {
            super(handle);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_InitializerCanBeStatic();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            Tree t = ctx.getPath().getLeaf();
            if (t.getKind() != Tree.Kind.BLOCK) {
                return;
            }
            BlockTree bl = (BlockTree)t;
            WorkingCopy wc = ctx.getWorkingCopy();
            GeneratorUtilities gu = GeneratorUtilities.get(wc);
            gu.importComments(bl, wc.getCompilationUnit());
            TreeMaker mk = wc.getTreeMaker();
            BlockTree nbl = mk.Block(bl.getStatements(), true);
            gu.copyComments(bl, nbl, true);
            gu.copyComments(bl, nbl, false);
            wc.rewrite(bl, nbl);
        }
    }
}

