/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.platform.implspi.JavaPlatformProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class DefaultJavaPlatformProvider
implements JavaPlatformProvider,
FileChangeListener {
    private static final String PLATFORM_STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private static final String DEFAULT_PLATFORM_ATTR = "default-platform";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject storageCache;
    private FileObject lastFound;
    private FileChangeListener pathListener;
    private JavaPlatform defaultPlatform;
    private static final Logger LOG = Logger.getLogger(DefaultJavaPlatformProvider.class.getName());

    @Override
    public JavaPlatform[] getInstalledPlatforms() {
        ArrayList<JavaPlatform> platforms = new ArrayList<JavaPlatform>();
        FileObject storage = this.getStorage();
        if (storage != null) {
            for (FileObject platformDefinition : storage.getChildren()) {
                try {
                    DataObject dobj = DataObject.find(platformDefinition);
                    InstanceCookie ic = dobj.getCookie(InstanceCookie.class);
                    if (ic == null) {
                        LOG.log(Level.WARNING, "The file: {0} has no InstanceCookie", platformDefinition.getNameExt());
                        continue;
                    }
                    if (ic instanceof InstanceCookie.Of) {
                        if (((InstanceCookie.Of)ic).instanceOf(JavaPlatform.class)) {
                            platforms.add((JavaPlatform)ic.instanceCreate());
                            continue;
                        }
                        LOG.log(Level.WARNING, "The file: {0} is not an instance of JavaPlatform", platformDefinition.getNameExt());
                        continue;
                    }
                    Object instance = ic.instanceCreate();
                    if (instance instanceof JavaPlatform) {
                        platforms.add((JavaPlatform)instance);
                        continue;
                    }
                    LOG.log(Level.WARNING, "The file: {0} is not an instance of JavaPlatform", platformDefinition.getNameExt());
                }
                catch (IOException | ClassNotFoundException e) {
                    Exceptions.printStackTrace(e);
                }
            }
        }
        return platforms.toArray(new JavaPlatform[platforms.size()]);
    }

    @Override
    public JavaPlatform getDefaultPlatform() {
        if (this.defaultPlatform == null) {
            this.defaultPlatform = this.getDefaultPlatformByHint();
            if (this.defaultPlatform != null) {
                return this.defaultPlatform;
            }
            JavaPlatform[] allPlatforms = this.getInstalledPlatforms();
            for (int i = 0; i < allPlatforms.length; ++i) {
                if (!this.isDefaultPlatform(allPlatforms[i])) continue;
                this.defaultPlatform = allPlatforms[i];
                break;
            }
        }
        return this.defaultPlatform;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.firePropertyChange();
    }

    @Override
    public void fileChanged(FileEvent fe) {
        this.firePropertyChange();
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        this.firePropertyChange();
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.firePropertyChange();
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void firePropertyChange() {
        this.pcs.firePropertyChange("installedPlatforms", null, null);
    }

    private boolean isDefaultPlatform(JavaPlatform platform) {
        return "default_platform".equals(platform.getProperties().get("platform.ant.name"));
    }

    private JavaPlatform getDefaultPlatformByHint() {
        FileObject storage = this.getStorage();
        if (storage != null) {
            for (FileObject defFile : storage.getChildren()) {
                if (defFile.getAttribute(DEFAULT_PLATFORM_ATTR) != Boolean.TRUE) continue;
                try {
                    Object instance;
                    DataObject dobj = DataObject.find(defFile);
                    InstanceCookie ic = dobj.getCookie(InstanceCookie.class);
                    if (ic != null && (instance = ic.instanceCreate()) instanceof JavaPlatform && this.isDefaultPlatform((JavaPlatform)instance)) {
                        return (JavaPlatform)instance;
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    private synchronized FileObject getStorage() {
        if (this.storageCache == null) {
            this.storageCache = FileUtil.getConfigFile(PLATFORM_STORAGE);
            if (this.storageCache != null) {
                this.storageCache.addFileChangeListener(this);
                this.removePathListener();
            } else {
                String pathElement;
                FileObject current;
                String[] path = PLATFORM_STORAGE.split("/");
                FileObject lastExist = FileUtil.getConfigRoot();
                String expected = null;
                String[] stringArray = path;
                int n = stringArray.length;
                for (int i = 0; i < n && (current = lastExist.getFileObject(expected = (pathElement = stringArray[i]))) != null; ++i) {
                    lastExist = current;
                }
                assert (lastExist != null);
                assert (expected != null);
                this.removePathListener();
                final String expectedFin = expected;
                this.pathListener = new FileChangeAdapter(){

                    @Override
                    public void fileFolderCreated(FileEvent fe) {
                        if (expectedFin.equals(fe.getFile().getName())) {
                            DefaultJavaPlatformProvider.this.firePropertyChange();
                        }
                    }
                };
                this.lastFound = lastExist;
                this.lastFound.addFileChangeListener(this.pathListener);
            }
        }
        return this.storageCache;
    }

    private void removePathListener() {
        if (this.pathListener != null) {
            assert (this.lastFound != null);
            this.lastFound.removeFileChangeListener(this.pathListener);
            this.pathListener = null;
            this.lastFound = null;
        }
    }
}

