/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.preprocessorbridge.api;

import java.io.IOException;
import java.util.Collection;
import jpt.sun.source.tree.ModuleTree;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.preprocessorbridge.JavaSourceUtilImplAccessor;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceUtilImpl;
import org.openide.util.Lookup;

public final class ModuleUtilities {
    private static final Lookup.Result<JavaSourceUtilImpl> result = Lookup.getDefault().lookupResult(JavaSourceUtilImpl.class);
    private final Object javaSource;
    private JavaSourceUtilImpl.ModuleInfoHandle handle = null;

    private ModuleUtilities(@NonNull Object javaSource) {
        this.javaSource = javaSource;
    }

    public static ModuleUtilities get(@NonNull Object javaSource) {
        return new ModuleUtilities(javaSource);
    }

    @CheckForNull
    public String parseModuleName() throws IOException {
        return this.init() ? this.handle.parseModuleName() : null;
    }

    @CheckForNull
    public ModuleTree parseModule() throws IOException {
        return this.init() ? this.handle.parseModule() : null;
    }

    @CheckForNull
    public ModuleElement resolveModule(@NonNull ModuleTree moduleTree) throws IOException {
        return this.init() ? this.handle.resolveModule(moduleTree) : null;
    }

    @CheckForNull
    public ModuleElement resolveModule(String moduleName) throws IOException {
        return this.init() ? this.handle.resolveModule(moduleName) : null;
    }

    @CheckForNull
    public TypeElement readClassFile() throws IOException {
        return this.init() ? this.handle.readClassFile() : null;
    }

    private boolean init() throws IOException {
        Collection<JavaSourceUtilImpl> instances;
        int size;
        if (this.handle == null && (size = (instances = result.allInstances()).size()) == 1) {
            this.handle = JavaSourceUtilImplAccessor.getInstance().getModuleInfoHandle(instances.iterator().next(), this.javaSource);
        }
        return this.handle != null;
    }
}

