/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.implspi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.impl.indexing.DefaultCacheFolderProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class CacheFolderProvider {
    private static final AtomicReference<Lookup.Result<CacheFolderProvider>> impls = new AtomicReference();

    protected CacheFolderProvider() {
    }

    @CheckForNull
    protected abstract FileObject findCacheFolderForRoot(@NonNull URL var1, @NonNull Set<Kind> var2, @NonNull Mode var3) throws IOException;

    @CheckForNull
    protected abstract URL findRootForCacheFolder(@NonNull FileObject var1) throws IOException;

    protected abstract void collectRootsInFolder(@NonNull URL var1, Collection<? super URL> var2) throws IOException;

    @CheckForNull
    public static FileObject getCacheFolderForRoot(@NonNull URL root, @NonNull Set<Kind> kinds, @NonNull Mode mode) throws IOException {
        assert (root != null);
        assert (kinds != null);
        assert (mode != null);
        for (CacheFolderProvider cacheFolderProvider : CacheFolderProvider.getImpls()) {
            FileObject result = cacheFolderProvider.findCacheFolderForRoot(root, kinds, mode);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @CheckForNull
    public static URL getRootForCacheFolder(@NonNull FileObject cacheFolder) throws IOException {
        assert (cacheFolder != null);
        for (CacheFolderProvider cacheFolderProvider : CacheFolderProvider.getImpls()) {
            URL result = cacheFolderProvider.findRootForCacheFolder(cacheFolder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NonNull
    public static Iterable<? extends URL> getRootsInFolder(@NonNull URL folder) throws IOException {
        assert (folder != null);
        ArrayDeque resCollector = new ArrayDeque();
        for (CacheFolderProvider cacheFolderProvider : CacheFolderProvider.getImpls()) {
            cacheFolderProvider.collectRootsInFolder(folder, resCollector);
        }
        return resCollector;
    }

    @NonNull
    private static Collection<? extends CacheFolderProvider> getImpls() {
        ProxyLookup lkp;
        Lookup.Result<CacheFolderProvider> res = impls.get();
        if (res == null && !impls.compareAndSet(null, res = (lkp = new ProxyLookup(Lookups.proxy(new Lookup.Provider(){

            @Override
            public Lookup getLookup() {
                return Lookup.getDefault();
            }
        }), Lookups.singleton(DefaultCacheFolderProvider.getInstance()))).lookupResult(CacheFolderProvider.class))) {
            res = impls.get();
        }
        return res.allInstances();
    }

    public static enum Mode {
        EXISTENT,
        CREATE;

    }

    public static enum Kind {
        SOURCES,
        LIBRARIES,
        BINARIES;

    }
}

