/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AdHocGroupEditPanel
extends GroupEditPanel {
    private final AdHocGroup g;
    private JCheckBox autoSynchCheckbox;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton synchButton;

    public AdHocGroupEditPanel(AdHocGroup g) {
        this.g = g;
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AdHocGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AdHocGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.nameField.setText(g.getName());
        this.nameField.getDocument().addDocumentListener(l);
        this.autoSynchCheckbox.setSelected(g.isAutoSynch());
        this.updateSynchButton();
    }

    @Override
    public void applyChanges() {
        this.g.setName(this.nameField.getText().trim());
        this.g.setAutoSynch(this.autoSynchCheckbox.isSelected());
    }

    private void updateSynchButton() {
        this.synchButton.setEnabled(!this.autoSynchCheckbox.isSelected() && !this.g.isPristine());
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.autoSynchCheckbox = new JCheckBox();
        this.synchButton = new JButton();
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText(this.nameLabel, NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.nameLabel.text"));
        Mnemonics.setLocalizedText(this.autoSynchCheckbox, NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.autoSynchCheckbox.text"));
        this.autoSynchCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoSynchCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdHocGroupEditPanel.this.autoSynchCheckboxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.synchButton, NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.synchButton.text"));
        this.synchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdHocGroupEditPanel.this.synchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -1, 470, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoSynchCheckbox).addComponent(this.synchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSynchCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.synchButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.nameField.AccessibleContext.accessibleName"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.nameField.AccessibleContext.accessibleDescription"));
        this.autoSynchCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.autoSynchCheckbox.AccessibleContext.accessibleDescription"));
        this.synchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.synchButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdHocGroupEditPanel.class, "AdHocGroupEditPanel.AccessibleContext.accessibleDescription"));
    }

    private void synchButtonActionPerformed(ActionEvent evt) {
        this.g.synch();
        this.updateSynchButton();
    }

    private void autoSynchCheckboxActionPerformed(ActionEvent evt) {
        this.updateSynchButton();
    }

    @Override
    public boolean isReady() {
        return this.doCheckExistingGroups(this.nameField, this.g);
    }
}

