/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.AsyncGUIJob;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

final class AsyncInitSupport
implements HierarchyListener,
Runnable,
ActionListener {
    private static final Object CANCELLED_LOCK = new Object();
    private static final Logger LOG = Logger.getLogger(AsyncInitSupport.class.getName());
    private Task initTask;
    private boolean wasCancelled;
    private Component comp4Init;
    private AsyncGUIJob initJob;
    Timer timer = null;

    public AsyncInitSupport(Component comp4Init, AsyncGUIJob initJob) {
        this.comp4Init = comp4Init;
        this.initJob = initJob;
        if (comp4Init.isShowing()) {
            throw new IllegalStateException("Component already shown, can't be inited: " + comp4Init);
        }
        comp4Init.addHierarchyListener(this);
        LOG.log(Level.FINE, "addHierarchyListener for {0}", comp4Init);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent evt) {
        boolean hierachyChanged = (evt.getChangeFlags() & 4L) != 0L;
        LOG.log(Level.FINE, "Hierarchy Changed {0}", hierachyChanged);
        if (hierachyChanged) {
            boolean isShowing = this.comp4Init.isShowing();
            if (this.timer == null && isShowing) {
                this.timer = new Timer(20, this);
                this.timer.setRepeats(false);
                this.timer.start();
                LOG.log(Level.FINE, "Timer started for {0}", this.comp4Init);
            } else if (!isShowing) {
                this.comp4Init.removeHierarchyListener(this);
                LOG.log(Level.FINE, "Not showing, cancling for {0}", this.comp4Init);
                this.cancel();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.wasCancelled || this.initTask != null) {
            LOG.log(Level.FINE, "Detaching {0}", this.comp4Init);
            this.detach();
            return;
        }
        if (this.comp4Init != null && this.comp4Init.isDisplayable()) {
            LOG.log(Level.FINE, "Starting {0}", this.comp4Init);
            this.start();
        }
    }

    private void start() {
        this.detach();
        if (this.initTask == null) {
            this.initTask = RequestProcessor.getDefault().post(this);
        }
    }

    private void detach() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean localCancel;
            LOG.log(Level.FINE, "Prepare outside AWT for {0}", this.comp4Init);
            this.initJob.construct();
            this.comp4Init.removeHierarchyListener(this);
            LOG.log(Level.FINE, "No hierarchy listener for {0}", this.comp4Init);
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                localCancel = this.wasCancelled;
            }
            LOG.log(Level.FINE, "wasCancelled {0}", localCancel);
            if (!localCancel) {
                SwingUtilities.invokeLater(this);
            }
        } else {
            this.initJob.finished();
            LOG.fine("Second pass finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        if (this.initTask != null && !this.initTask.isFinished() && this.initJob instanceof Cancellable) {
            Object object = CANCELLED_LOCK;
            synchronized (object) {
                LOG.log(Level.FINE, "Cancelling for {0}", this.comp4Init);
                this.wasCancelled = true;
            }
            ((Cancellable)((Object)this.initJob)).cancel();
            LOG.fine("Cancelling done");
        }
    }
}

