/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.openide.filesystems.FileObject;

/**
 * Result of changes performed by refactoring plugin.
 * @author Jan Becicka
 * @since 1.23
 */
public interface ModificationResult {

    /**
     * New source text for given file. 
     * 
     * @param file
     * @return new source text
     * @throws IOException
     * @throws IllegalArgumentException
     */
    public String getResultingSource(FileObject file) throws IOException, IllegalArgumentException;
    
    /**
     * FileObjects modified by this ModificationResult.
     * @return
     */
    public Collection<? extends FileObject> getModifiedFileObjects();

    /**
     * New files generated by this ModificationResult.
     * @return 
     */
    public Collection<? extends File> getNewFiles();

    /**
     * Performs commit of changes into files.
     * @throws IOException 
     */
    public void commit() throws IOException;
    
}
