/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.templates.ui;

import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.util.NbBundle;

/**
 * Handles rename of a template file name and display name.
 * 
 * @author Martin Entlicher
 */
public class RenameTemplatePanel extends java.awt.Panel {
    
    private Set<String> otherFileNames;
    private boolean isLicense = false;
    private DialogDescriptor dd;
    private NotificationLineSupport notificationLineSupport;

    /** Creates new form RenameTemplatePanel */
    public RenameTemplatePanel(boolean isUserFile) {
        initComponents();
        fileNameTextField.setEditable(isUserFile);
        fileNameTextField.getDocument().addDocumentListener(new NameDocumentListener());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        displayNameLabel = new javax.swing.JLabel();
        displayNameTextField = new javax.swing.JTextField();
        fileNameLabel = new javax.swing.JLabel();
        fileNameTextField = new javax.swing.JTextField();

        displayNameLabel.setLabelFor(displayNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(displayNameLabel, org.openide.util.NbBundle.getMessage(RenameTemplatePanel.class, "RenameTemplatePanel.displayNameLabel.text")); // NOI18N

        fileNameLabel.setLabelFor(fileNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(fileNameLabel, org.openide.util.NbBundle.getMessage(RenameTemplatePanel.class, "RenameTemplatePanel.fileNameLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(displayNameLabel)
                    .addComponent(fileNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fileNameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE)
                    .addComponent(displayNameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(displayNameLabel)
                    .addComponent(displayNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(fileNameLabel)
                    .addComponent(fileNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel displayNameLabel;
    private javax.swing.JTextField displayNameTextField;
    private javax.swing.JLabel fileNameLabel;
    private javax.swing.JTextField fileNameTextField;
    // End of variables declaration//GEN-END:variables

    void setFileName(String name) {
        fileNameTextField.setText(name);
    }

    void setFileDisplayName(String name) {
        displayNameTextField.setText(name);
    }

    String getFileName() {
        return fileNameTextField.getText();
    }

    String getFileDisplayName() {
        return displayNameTextField.getText();
    }
    
    void setIsLicense(boolean isLicense) {
        this.isLicense = isLicense;
    }

    void setOtherFileNames(Set<String> otherFileNames) {
        this.otherFileNames = otherFileNames;
    }

    void setDescriptor(DialogDescriptor dd) {
        this.dd = dd;
        this.notificationLineSupport = dd.createNotificationLineSupport();
    }

    @NbBundle.Messages({"Err_FileNameExists=Template with this file name already exists.",
                        "# {0} - prefix of the license file name",
                        "# {1} - suffix of the license file name",
                        "RenameTemplatePanel.license.warning.text=License file name must start with \"{0}\" and end with \"{1}\"."})
    private void checkName() {
        String name = fileNameTextField.getText();
        boolean clash = otherFileNames != null && otherFileNames.contains(name);
        if (clash) {
            notificationLineSupport.setErrorMessage(Bundle.Err_FileNameExists());
        } else {
            clash = isLicense && checkLicenseClash(name);
            if (clash) {
                notificationLineSupport.setErrorMessage(
                        Bundle.RenameTemplatePanel_license_warning_text(
                            TemplatesPanel.LICENSE_NAME_START,
                            TemplatesPanel.LICENSE_NAME_END));
            } else {
                notificationLineSupport.clearMessages();
            }
        }
        dd.setValid(!clash);
    }
    
    private static boolean checkLicenseClash(String name) {
        return !name.startsWith(TemplatesPanel.LICENSE_NAME_START) ||
               !name.endsWith(TemplatesPanel.LICENSE_NAME_END);
    }

    private class NameDocumentListener implements DocumentListener {

        public NameDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            checkName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            checkName();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            checkName();
        }
        
    }

}
