/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.web.clientproject;

/**
 *
 */
public class ClientSideProjectConstants {

    // misc persistent project properties:
    public static final String PROJECT_ENCODING = "files.encoding"; //NOI18N
    public static final String PROJECT_SOURCE_FOLDER = "source.folder"; //NOI18N
    public static final String PROJECT_SITE_ROOT_FOLDER = "site.root.folder"; //NOI18N
    public static final String PROJECT_TEST_FOLDER = "test.folder"; //NOI18N
    public static final String PROJECT_TEST_SELENIUM_FOLDER = "test.selenium.folder"; //NOI18N
    public static final String PROJECT_SERVER = "server"; //NOI18N
    public static final String PROJECT_START_FILE = "start.file"; //NOI18N
    public static final String PROJECT_WEB_ROOT = "web.context.root"; //NOI18N
    public static final String PROJECT_PROJECT_URL = "external.project.url"; //NOI18N
    public static final String PROJECT_AUTO_REFRESH = "browser.autorefresh"; //NOI18N
    public static final String PROJECT_HIGHLIGHT_SELECTION = "browser.highlightselection"; //NOI18N
    public static final String PROJECT_SELECTED_BROWSER = "browser"; //NOI18N
    public static final String PROJECT_RUN_BROWSER = "browser.run"; //NOI18N
    public static final String PROJECT_RUN_AS = "run.as"; //NOI18N
    public static final String PROJECT_AUTOCONFIGURED = "autoconfigured"; //NOI18N

    // default paths:
    public static final String DEFAULT_SOURCE_FOLDER = "src"; //NOI18N
    public static final String DEFAULT_SITE_ROOT_FOLDER = "public_html"; //NOI18N
    public static final String DEFAULT_TEST_FOLDER = "test"; //NOI18N
    public static final String DEFAULT_TEST_SELENIUM_FOLDER = "selenium"; //NOI18N
    
    // template's descriptor file
    public static final String TEMPLATE_DESCRIPTOR = "netbeans-project.properties"; //NOI18N
}
