/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.status.ProcessingPerformanceStatusDTO;

@XmlType(name="processorStatusSnapshot")
public class ProcessorStatusSnapshotDTO
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private String type;
    private String runStatus;
    private String executionNode;
    private Long bytesRead = 0L;
    private Long bytesWritten = 0L;
    private String read;
    private String written;
    private Integer flowFilesIn = 0;
    private Long bytesIn = 0L;
    private String input;
    private Integer flowFilesOut = 0;
    private Long bytesOut = 0L;
    private String output;
    private Integer taskCount = 0;
    private Long tasksDurationNanos = 0L;
    private String tasks;
    private String tasksDuration;
    private Integer activeThreadCount = 0;
    private Integer terminatedThreadCount = 0;
    @ApiModelProperty(value="Represents the processor's processing performance.")
    private ProcessingPerformanceStatusDTO processingPerformanceStatus;

    @ApiModelProperty(value="The id of the processor.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The name of the prcessor.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The type of the processor.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="The state of the processor.", allowableValues="Running, Stopped, Validating, Disabled, Invalid")
    public String getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    @ApiModelProperty(value="Indicates the node where the process will execute.", allowableValues="ALL, PRIMARY")
    public String getExecutionNode() {
        return this.executionNode;
    }

    public void setExecutionNode(String executionNode) {
        this.executionNode = executionNode;
    }

    @ApiModelProperty(value="The count/size of flowfiles that have been accepted in the last 5 minutes.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    @ApiModelProperty(value="The number of bytes read in the last 5 minutes.")
    public String getRead() {
        return this.read;
    }

    public void setRead(String read) {
        this.read = read;
    }

    @ApiModelProperty(value="The number of bytes written in the last 5 minutes.")
    public String getWritten() {
        return this.written;
    }

    public void setWritten(String written) {
        this.written = written;
    }

    @ApiModelProperty(value="The id of the parent process group to which the processor belongs.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The count/size of flowfiles that have been processed in the last 5 minutes.")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @ApiModelProperty(value="The number of threads currently executing in the processor.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer threadCount) {
        this.activeThreadCount = threadCount;
    }

    @ApiModelProperty(value="The number of threads currently terminated for the processor.")
    public Integer getTerminatedThreadCount() {
        return this.terminatedThreadCount;
    }

    public void setTerminatedThreadCount(Integer terminatedThreadCount) {
        this.terminatedThreadCount = terminatedThreadCount;
    }

    @ApiModelProperty(value="The total number of task this connectable has completed over the last 5 minutes.")
    public String getTasks() {
        return this.tasks;
    }

    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    @ApiModelProperty(value="The total duration of all tasks for this connectable over the last 5 minutes.")
    public String getTasksDuration() {
        return this.tasksDuration;
    }

    public void setTasksDuration(String tasksDuration) {
        this.tasksDuration = tasksDuration;
    }

    @ApiModelProperty(value="The number of bytes read by this Processor in the last 5 mintues")
    public Long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    @ApiModelProperty(value="The number of bytes written by this Processor in the last 5 minutes")
    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(Long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    @ApiModelProperty(value="The number of FlowFiles that have been accepted in the last 5 minutes")
    public Integer getFlowFilesIn() {
        return this.flowFilesIn;
    }

    public void setFlowFilesIn(Integer flowFilesIn) {
        this.flowFilesIn = flowFilesIn;
    }

    @ApiModelProperty(value="The size of the FlowFiles that have been accepted in the last 5 minutes")
    public Long getBytesIn() {
        return this.bytesIn;
    }

    public void setBytesIn(Long bytesIn) {
        this.bytesIn = bytesIn;
    }

    @ApiModelProperty(value="The number of FlowFiles transferred to a Connection in the last 5 minutes")
    public Integer getFlowFilesOut() {
        return this.flowFilesOut;
    }

    public void setFlowFilesOut(Integer flowFilesOut) {
        this.flowFilesOut = flowFilesOut;
    }

    @ApiModelProperty(value="The size of the FlowFiles transferred to a Connection in the last 5 minutes")
    public Long getBytesOut() {
        return this.bytesOut;
    }

    public void setBytesOut(Long bytesOut) {
        this.bytesOut = bytesOut;
    }

    @ApiModelProperty(value="The number of times this Processor has run in the last 5 minutes")
    public Integer getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(Integer taskCount) {
        this.taskCount = taskCount;
    }

    @ApiModelProperty(value="The number of nanoseconds that this Processor has spent running in the last 5 minutes")
    public Long getTasksDurationNanos() {
        return this.tasksDurationNanos;
    }

    public void setTasksDurationNanos(Long taskNanos) {
        this.tasksDurationNanos = taskNanos;
    }

    public ProcessingPerformanceStatusDTO getProcessingPerformanceStatus() {
        return this.processingPerformanceStatus;
    }

    public void setProcessingPerformanceStatus(ProcessingPerformanceStatusDTO processingPerformanceStatus) {
        this.processingPerformanceStatus = processingPerformanceStatus;
    }

    public ProcessorStatusSnapshotDTO clone() {
        ProcessorStatusSnapshotDTO other = new ProcessorStatusSnapshotDTO();
        other.setId(this.getId());
        other.setGroupId(this.getGroupId());
        other.setName(this.getName());
        other.setType(this.getType());
        other.setRunStatus(this.getRunStatus());
        other.setExecutionNode(this.getExecutionNode());
        other.setBytesRead(this.getBytesRead());
        other.setBytesWritten(this.getBytesWritten());
        other.setFlowFilesIn(this.getFlowFilesIn());
        other.setBytesIn(this.getBytesIn());
        other.setFlowFilesOut(this.getFlowFilesOut());
        other.setBytesOut(this.getBytesOut());
        other.setTaskCount(this.getTaskCount());
        other.setTasksDuration(this.getTasksDuration());
        other.setTasksDurationNanos(this.getTasksDurationNanos());
        other.setActiveThreadCount(this.getActiveThreadCount());
        other.setTerminatedThreadCount(this.getTerminatedThreadCount());
        other.setInput(this.getInput());
        other.setOutput(this.getOutput());
        other.setRead(this.getRead());
        other.setWritten(this.getWritten());
        other.setTasks(this.getTasks());
        other.setProcessingPerformanceStatus(this.getProcessingPerformanceStatus());
        return other;
    }
}

